/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import net.jitl.common.items.base.MultitoolItem;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.BlockHitResult;

public class JGrassBlock
extends Block {
    public JGrassBlock() {
        super(JBlockProperties.GRASS);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        Item itemstack = pPlayer.m_21120_(pHand).m_41720_();
        Block dirt = this.getFarmlandFromGrass();
        if (itemstack instanceof HoeItem || itemstack instanceof MultitoolItem) {
            if (dirt != null) {
                pLevel.m_5594_(pPlayer, pPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!pLevel.f_46443_) {
                    pLevel.m_7731_(pPos, dirt.m_49966_(), 2);
                    if (!pPlayer.m_7500_()) {
                        pPlayer.m_21120_(pHand).m_220157_(1, pLevel.f_46441_, (ServerPlayer)pPlayer);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Block getFarmlandFromGrass() {
        Block farmland = null;
        if (this == JBlocks.GOLDITE_GRASS.get() || this == JBlocks.EUCA_GOLD_GRASS.get()) {
            farmland = (Block)JBlocks.GOLDITE_FARMLAND.get();
        }
        if (this == JBlocks.GRASSY_PERMAFROST.get()) {
            farmland = (Block)JBlocks.PERMAFROST_FARMLAND.get();
        }
        if (this == JBlocks.DEPTHS_GRASS.get()) {
            farmland = (Block)JBlocks.DEPTHS_FARMLAND.get();
        }
        if (this == JBlocks.CORBA_GRASS.get()) {
            farmland = (Block)JBlocks.CORBA_FARMLAND.get();
        }
        if (this == JBlocks.TERRANIAN_GRASS.get()) {
            farmland = (Block)JBlocks.TERRANIAN_GRASS.get();
        }
        if (this == JBlocks.CLOUDIA_GRASS.get()) {
            farmland = (Block)JBlocks.CLOUDIA_GRASS.get();
        }
        return farmland;
    }

    public Block getDirtFromGrass() {
        Block dirt = null;
        if (this == JBlocks.GOLDITE_GRASS.get() || this == JBlocks.EUCA_GOLD_GRASS.get()) {
            dirt = (Block)JBlocks.GOLDITE_DIRT.get();
        }
        if (this == JBlocks.GRASSY_PERMAFROST.get()) {
            dirt = (Block)JBlocks.CRUMBLED_PERMAFROST.get();
        }
        if (this == JBlocks.CHARRED_GRASS.get()) {
            dirt = (Block)JBlocks.RUBBLE.get();
        }
        if (this == JBlocks.DEPTHS_GRASS.get()) {
            dirt = (Block)JBlocks.DEPTHS_DIRT.get();
        }
        if (this == JBlocks.CORBA_GRASS.get()) {
            dirt = (Block)JBlocks.CORBA_DIRT.get();
        }
        if (this == JBlocks.TERRANIAN_GRASS.get()) {
            dirt = (Block)JBlocks.TERRANIAN_DIRT.get();
        }
        if (this == JBlocks.CLOUDIA_GRASS.get()) {
            dirt = (Block)JBlocks.CLOUDIA_DIRT.get();
        }
        return dirt;
    }

    private static boolean canBeGrass(BlockState pState, LevelReader pLevelReader, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        BlockState blockstate = pLevelReader.m_8055_(blockpos);
        int i = LightEngine.m_284282_((BlockGetter)pLevelReader, (BlockState)pState, (BlockPos)pPos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)pLevelReader, blockpos));
        return i < pLevelReader.m_7469_();
    }

    private static boolean canPropagate(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7494_();
        return JGrassBlock.canBeGrass(pState, pLevel, pPos) && !pLevel.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!JGrassBlock.canBeGrass(pState, (LevelReader)pLevel, pPos)) {
            if (!pLevel.isAreaLoaded(pPos, 1)) {
                return;
            }
            pLevel.m_46597_(pPos, this.getDirtFromGrass().m_49966_());
        } else {
            if (!pLevel.isAreaLoaded(pPos, 3)) {
                return;
            }
            if (pLevel.m_46803_(pPos.m_7494_()) >= 9) {
                BlockState blockstate = this.m_49966_();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pPos.m_7918_(pRandom.m_188503_(3) - 1, pRandom.m_188503_(5) - 3, pRandom.m_188503_(3) - 1);
                    if (!pLevel.m_8055_(blockpos).m_60713_(this.getDirtFromGrass()) || !JGrassBlock.canPropagate(blockstate, (LevelReader)pLevel, blockpos)) continue;
                    pLevel.m_7731_(blockpos, blockstate, 4);
                }
            }
        }
    }
}

