/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jitl.common.block.entity.SummoningTableTile;
import net.jitl.core.config.JCommonConfig;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class SummoningTableBlock
extends BaseEntityBlock {
    public static final BooleanProperty IS_ACTIVE = BooleanProperty.m_61465_((String)"is_active");
    public static final BooleanProperty SUMMON = BooleanProperty.m_61465_((String)"summon");
    public static BlockPattern STRUCTURE_PATTERN;

    public SummoningTableBlock(BlockBehaviour.Properties p) {
        super(p);
        SummoningTableBlock.getOrCreateStructurePattern();
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.FALSE));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SUMMON, (Comparable)Boolean.FALSE));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)IS_ACTIVE, (Comparable)Boolean.FALSE)).m_61124_((Property)SUMMON, (Comparable)Boolean.FALSE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IS_ACTIVE});
        builder.m_61104_(new Property[]{SUMMON});
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)JBlockEntities.SUMMONING_TABLE.get()).m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> entity) {
        return level.f_46443_ ? null : SummoningTableBlock.m_152132_(entity, (BlockEntityType)((BlockEntityType)JBlockEntities.SUMMONING_TABLE.get()), SummoningTableTile::serverTick);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof SummoningTableTile && (this.isUsable(level, pos) || player.m_7500_())) {
            player.m_5893_((MenuProvider)((SummoningTableTile)blockentity));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pos, RandomSource pRandom) {
        for (int i = 0; i < 10; ++i) {
            if (pRandom.m_188503_(5) != 0) continue;
            double d0 = (double)pos.m_123341_() + (double)pRandom.m_188501_();
            double d1 = (double)pos.m_123342_() + 1.0;
            double d2 = (double)pos.m_123343_() + (double)pRandom.m_188501_();
            if (!this.isUsable(pLevel, pos)) continue;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123809_, d0, d1, d2, 0.0, 0.0, 0.0);
            if (((Boolean)pState.m_61143_((Property)IS_ACTIVE)).booleanValue()) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123809_, d0, d1 + 0.2, d2, 0.0, 0.0, 0.0);
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123797_, d0, d1 + 0.2, d2, 0.0, 0.0, 0.0);
            }
            if (!this.getIsSummoning(pState)) continue;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() - Mth.m_216263_((RandomSource)pRandom, (double)-0.45, (double)0.75), (double)pos.m_123342_() + Mth.m_216263_((RandomSource)pRandom, (double)0.5, (double)2.0), (double)pos.m_123343_() - Mth.m_216263_((RandomSource)pRandom, (double)-0.45, (double)0.75), pRandom.m_188583_() * 0.05, 0.15, pRandom.m_188583_() * 0.05);
        }
    }

    public boolean getIsSummoning(BlockState state) {
        return (Boolean)state.m_61143_((Property)SUMMON);
    }

    public boolean isUsable(Level level, BlockPos pos) {
        return STRUCTURE_PATTERN.m_61184_((LevelReader)level, pos.m_6625_(1).m_122013_(2).m_122025_(2)) != null || (Boolean)JCommonConfig.NEED_SUMMONING_STRUCTURE.get() == false;
    }

    public void m_6810_(BlockState state, Level level, @NotNull BlockPos pos, BlockState blockState, boolean b) {
        if (!state.m_60713_(blockState.m_60734_())) {
            BlockEntity blockentity = level.m_7702_(pos);
            if (blockentity instanceof SummoningTableTile) {
                if (level instanceof ServerLevel) {
                    Containers.m_19002_((Level)level, (BlockPos)pos, (Container)((SummoningTableTile)blockentity));
                }
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, blockState, b);
        }
    }

    public static void getOrCreateStructurePattern() {
        if (STRUCTURE_PATTERN == null) {
            STRUCTURE_PATTERN = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"_kek_", "l___l", "l___l", "cs_sc", "_____"}).m_61247_(new String[]{"k_k_k", "_____", "_____", "ss_ss", "_sss_"}).m_61247_(new String[]{"ekkke", "_____", "_____", "__o__", "_sss_"}).m_61247_(new String[]{"k_k_k", "_____", "_____", "ss_ss", "_sss_"}).m_61247_(new String[]{"_kek_", "l___l", "l___l", "cs_sc", "_____"}).m_61244_('_', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.f_61281_)).m_61244_('k', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)JBlocks.BLOOD_ROCK.get())))).m_61244_('e', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)JBlocks.BLOOD_RUNE.get())))).m_61244_('l', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)JBlocks.BLOOD_PILLAR.get())))).m_61244_('c', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)JBlocks.CARVED_BLOOD_ROCK.get())))).m_61244_('s', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)JBlocks.BLOOD_BRICKS.get())))).m_61244_('o', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)JBlocks.OBELISK.get())))).m_61249_();
        }
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState pState) {
        return RenderShape.MODEL;
    }
}

