/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AttachedBlock
extends Block {
    protected static final VoxelShape DOWN_AABB = Block.m_49796_((double)3.0, (double)11.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    protected static final VoxelShape UP_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)3.0, (double)3.0, (double)11.0, (double)13.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)5.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)11.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)5.0, (double)13.0, (double)13.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public AttachedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        switch (direction) {
            case DOWN: {
                return DOWN_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
        }
        return UP_AABB;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!state.m_60710_((LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
        }
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext blockItemUseContext) {
        BlockState blockstate = this.m_49966_();
        Level worldReader = blockItemUseContext.m_43725_();
        BlockPos blockPos = blockItemUseContext.m_8083_();
        Direction[] directions = blockItemUseContext.m_6232_();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction = directions[i];
            Direction direction2 = direction.m_122424_();
            if (!(blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)direction2)).m_60710_((LevelReader)worldReader, blockPos)) continue;
            return blockstate;
        }
        return null;
    }

    public boolean m_7898_(BlockState blockState, LevelReader reader, BlockPos blockPos) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        BlockPos newPos = blockPos.m_121945_(direction.m_122424_());
        BlockState newState = reader.m_8055_(newPos);
        return newState.m_60783_((BlockGetter)reader, newPos, direction) && newState != Blocks.f_50752_.m_49966_();
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.m_60710_((LevelReader)worldIn, currentPos)) {
            worldIn.m_186460_(currentPos, (Block)this, 1);
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_6843_(BlockState b, Rotation r) {
        return (BlockState)b.m_61124_((Property)FACING, (Comparable)r.m_55954_((Direction)b.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState b, Mirror m) {
        return b.m_60717_(m.m_54846_((Direction)b.m_61143_((Property)FACING)));
    }
}

