/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import net.jitl.core.init.internal.JBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import org.jetbrains.annotations.NotNull;

public abstract class JFarmlandBlock
extends Block {
    public static final IntegerProperty MOISTURE = BlockStateProperties.f_61423_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public JFarmlandBlock() {
        super(JBlockProperties.FARMLAND);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public abstract Block setDirt();

    @NotNull
    public BlockState m_7417_(@NotNull BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (pFacing == Direction.UP && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            pLevel.m_186460_(pCurrentPos, (Block)this, 1);
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_7898_(@NotNull BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_7494_());
        return !blockstate.m_280296_() || blockstate.m_60734_() instanceof FenceGateBlock || blockstate.m_60734_() instanceof MovingPistonBlock;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return !this.m_49966_().m_60710_((LevelReader)pContext.m_43725_(), pContext.m_8083_()) ? this.setDirt().m_49966_() : super.m_5573_(pContext);
    }

    public boolean m_7923_(@NotNull BlockState pState) {
        return true;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    public void m_213897_(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            this.turnToDirt(pState, (Level)pLevel, pPos);
        }
    }

    public void m_213898_(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        int i = (Integer)pState.m_61143_((Property)MOISTURE);
        if (!JFarmlandBlock.isNearWater((LevelReader)pLevel, pPos) && !pLevel.m_46758_(pPos.m_7494_())) {
            if (i > 0) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!JFarmlandBlock.isUnderCrops((BlockGetter)pLevel, pPos)) {
                this.turnToDirt(pState, (Level)pLevel, pPos);
            }
        } else if (i < 7) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void m_142072_(Level pLevel, @NotNull BlockState pState, @NotNull BlockPos pPos, @NotNull Entity pEntity, float pFallDistance) {
        if (!pLevel.f_46443_ && ForgeHooks.onFarmlandTrample((Level)pLevel, (BlockPos)pPos, (BlockState)this.setDirt().m_49966_(), (float)pFallDistance, (Entity)pEntity)) {
            this.turnToDirt(pState, pLevel, pPos);
        }
        super.m_142072_(pLevel, pState, pPos, pEntity, pFallDistance);
    }

    public void turnToDirt(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.m_46597_(pPos, JFarmlandBlock.m_49897_((BlockState)pState, (BlockState)this.setDirt().m_49966_(), (LevelAccessor)pLevel, (BlockPos)pPos));
    }

    private static boolean isUnderCrops(BlockGetter pLevel, BlockPos pPos) {
        BlockState plant = pLevel.m_8055_(pPos.m_7494_());
        BlockState state = pLevel.m_8055_(pPos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(pLevel, pPos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    private static boolean isNearWater(LevelReader pLevel, BlockPos pPos) {
        BlockState state = pLevel.m_8055_(pPos);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pPos.m_7918_(-4, 0, -4), (BlockPos)pPos.m_7918_(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)pLevel, pPos, pLevel.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)pLevel, (BlockPos)pPos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{MOISTURE});
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }
}

