/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import net.jitl.core.init.internal.JBlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;

public class JLeavesBlock
extends Block
implements SimpleWaterloggedBlock,
IForgeShearable {
    public static final IntegerProperty DISTANCE = BlockStateProperties.f_61414_;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public JLeavesBlock() {
        super(JBlockProperties.LEAVES);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(7))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    @NotNull
    public VoxelShape m_7947_(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return Shapes.m_83040_();
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)DISTANCE) == 7 && (Boolean)pState.m_61143_((Property)PERSISTENT) == false;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (this.decaying(state)) {
            JLeavesBlock.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            level.m_7471_(pos, false);
        }
    }

    protected boolean decaying(BlockState s) {
        return (Boolean)s.m_61143_((Property)PERSISTENT) == false && (Integer)s.m_61143_((Property)DISTANCE) == 7;
    }

    public void m_213897_(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        level.m_7731_(pos, JLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    public int m_7753_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 1;
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        int i;
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((i = JLeavesBlock.getDistanceAt(facingState) + 1) != 1 || (Integer)pState.m_61143_((Property)DISTANCE) != i) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return pState;
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int i = 7;
        BlockPos.MutableBlockPos b = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            b.m_122159_((Vec3i)pos, direction);
            i = Math.min(i, JLeavesBlock.getDistanceAt(level.m_8055_((BlockPos)b)) + 1);
            if (i == 1) break;
        }
        return (BlockState)state.m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(i));
    }

    private static int getDistanceAt(BlockState neighbor) {
        if (neighbor.m_204336_(BlockTags.f_13106_)) {
            return 0;
        }
        return neighbor.m_60734_() instanceof JLeavesBlock || neighbor.m_60734_() instanceof LeavesBlock ? (Integer)neighbor.m_61143_((Property)DISTANCE) : 7;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_214162_(@NotNull BlockState state, Level level, BlockPos pos, @NotNull RandomSource random) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!level.m_46758_(pos.m_7494_()) || random.m_188503_(15) != 1 || (blockstate = level.m_8055_(blockpos = pos.m_7495_())).m_60815_() && blockstate.m_60783_((BlockGetter)level, blockpos, Direction.UP))) {
            double d0 = (double)pos.m_123341_() + random.m_188500_();
            double d1 = (double)pos.m_123342_() - 0.05;
            double d2 = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISTANCE, PERSISTENT, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        BlockState blockstate = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)PERSISTENT, (Comparable)Boolean.TRUE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return JLeavesBlock.updateDistance(blockstate, (LevelAccessor)pContext.m_43725_(), pContext.m_8083_());
    }
}

