/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.base;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class JWallBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BlockStateProperties.f_61366_;
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.f_61378_;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.f_61379_;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.f_61380_;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.f_61381_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final VoxelShape POST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public JWallBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.TRUE)).m_61124_(NORTH_WALL, (Comparable)WallSide.NONE)).m_61124_(EAST_WALL, (Comparable)WallSide.NONE)).m_61124_(SOUTH_WALL, (Comparable)WallSide.NONE)).m_61124_(WEST_WALL, (Comparable)WallSide.NONE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
        this.shapeByIndex = this.makeShapes(16.0f, 14.0f, 16.0f);
        this.collisionShapeByIndex = this.makeShapes(24.0f, 24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape pBaseShape, WallSide pHeight, VoxelShape pLowShape, VoxelShape pTallShape) {
        if (pHeight == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)pBaseShape, (VoxelShape)pTallShape);
        }
        return pHeight == WallSide.LOW ? Shapes.m_83110_((VoxelShape)pBaseShape, (VoxelShape)pLowShape) : pBaseShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float pWallPostHeight, float pWallLowHeight, float pWallTallHeight) {
        float f = 4.0f;
        float f1 = 12.0f;
        float f2 = 5.0f;
        float f3 = 11.0f;
        VoxelShape voxelshape = Block.m_49796_((double)f, (double)0.0, (double)f, (double)f1, (double)pWallPostHeight, (double)f1);
        VoxelShape voxelshape1 = Block.m_49796_((double)f2, (double)0.0, (double)0.0, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape2 = Block.m_49796_((double)f2, (double)0.0, (double)f2, (double)f3, (double)pWallLowHeight, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)0.0, (double)f2, (double)f3, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape4 = Block.m_49796_((double)f2, (double)0.0, (double)f2, (double)16.0, (double)pWallLowHeight, (double)f3);
        VoxelShape voxelshape5 = Block.m_49796_((double)f2, (double)0.0, (double)0.0, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape6 = Block.m_49796_((double)f2, (double)0.0, (double)f2, (double)f3, (double)pWallTallHeight, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)0.0, (double)f2, (double)f3, (double)pWallTallHeight, (double)f3);
        VoxelShape voxelshape8 = Block.m_49796_((double)f2, (double)0.0, (double)f2, (double)16.0, (double)pWallTallHeight, (double)f3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Boolean obool : UP.m_6908_()) {
            for (WallSide wallside : EAST_WALL.m_6908_()) {
                for (WallSide wallside1 : NORTH_WALL.m_6908_()) {
                    for (WallSide wallside2 : WEST_WALL.m_6908_()) {
                        for (WallSide wallside3 : SOUTH_WALL.m_6908_()) {
                            VoxelShape voxelshape9 = Shapes.m_83040_();
                            voxelshape9 = JWallBlock.applyWallShape(voxelshape9, wallside, voxelshape4, voxelshape8);
                            voxelshape9 = JWallBlock.applyWallShape(voxelshape9, wallside2, voxelshape3, voxelshape7);
                            voxelshape9 = JWallBlock.applyWallShape(voxelshape9, wallside1, voxelshape1, voxelshape5);
                            voxelshape9 = JWallBlock.applyWallShape(voxelshape9, wallside3, voxelshape2, voxelshape6);
                            if (obool.booleanValue()) {
                                voxelshape9 = Shapes.m_83110_((VoxelShape)voxelshape9, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)obool)).m_61124_(EAST_WALL, (Comparable)wallside)).m_61124_(WEST_WALL, (Comparable)wallside2)).m_61124_(NORTH_WALL, (Comparable)wallside1)).m_61124_(SOUTH_WALL, (Comparable)wallside3);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)), (Object)voxelshape9);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE)), (Object)voxelshape9);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return this.shapeByIndex.get(pState);
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return this.collisionShapeByIndex.get(pState);
    }

    public boolean m_7357_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull PathComputationType pType) {
        return false;
    }

    private boolean connectsTo(BlockState pState, boolean pSideSolid, Direction pDirection) {
        Block block = pState.m_60734_();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)pState, (Direction)pDirection);
        return pState.m_204336_(BlockTags.f_13032_) || block instanceof JWallBlock || block instanceof WallBlock || !JWallBlock.m_152463_((BlockState)pState) && pSideSolid || block instanceof IronBarsBlock || flag;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level levelreader = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        BlockPos blockpos1 = blockpos.m_122012_();
        BlockPos blockpos2 = blockpos.m_122029_();
        BlockPos blockpos3 = blockpos.m_122019_();
        BlockPos blockpos4 = blockpos.m_122024_();
        BlockPos blockpos5 = blockpos.m_7494_();
        BlockState blockstate = levelreader.m_8055_(blockpos1);
        BlockState blockstate1 = levelreader.m_8055_(blockpos2);
        BlockState blockstate2 = levelreader.m_8055_(blockpos3);
        BlockState blockstate3 = levelreader.m_8055_(blockpos4);
        BlockState blockstate4 = levelreader.m_8055_(blockpos5);
        boolean flag = this.connectsTo(blockstate, blockstate.m_60783_((BlockGetter)levelreader, blockpos1, Direction.SOUTH), Direction.SOUTH);
        boolean flag1 = this.connectsTo(blockstate1, blockstate1.m_60783_((BlockGetter)levelreader, blockpos2, Direction.WEST), Direction.WEST);
        boolean flag2 = this.connectsTo(blockstate2, blockstate2.m_60783_((BlockGetter)levelreader, blockpos3, Direction.NORTH), Direction.NORTH);
        boolean flag3 = this.connectsTo(blockstate3, blockstate3.m_60783_((BlockGetter)levelreader, blockpos4, Direction.EAST), Direction.EAST);
        BlockState blockstate5 = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return this.updateShape((LevelReader)levelreader, blockstate5, blockpos5, blockstate4, flag, flag1, flag2, flag3);
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, @NotNull Direction pFacing, @NotNull BlockState pFacingState, @NotNull LevelAccessor pLevel, @NotNull BlockPos pCurrentPos, @NotNull BlockPos pFacingPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (pFacing == Direction.DOWN) {
            return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        return pFacing == Direction.UP ? this.topUpdate((LevelReader)pLevel, pState, pFacingPos, pFacingState) : this.sideUpdate((LevelReader)pLevel, pCurrentPos, pState, pFacingPos, pFacingState, pFacing);
    }

    private static boolean isConnected(BlockState pState, Property<WallSide> pHeightProperty) {
        return pState.m_61143_(pHeightProperty) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape pFirstShape, VoxelShape pSecondShape) {
        return !Shapes.m_83157_((VoxelShape)pSecondShape, (VoxelShape)pFirstShape, (BooleanOp)BooleanOp.f_82685_);
    }

    private BlockState topUpdate(LevelReader pLevel, BlockState pState, BlockPos pPos, BlockState pSecondState) {
        boolean flag = JWallBlock.isConnected(pState, NORTH_WALL);
        boolean flag1 = JWallBlock.isConnected(pState, EAST_WALL);
        boolean flag2 = JWallBlock.isConnected(pState, SOUTH_WALL);
        boolean flag3 = JWallBlock.isConnected(pState, WEST_WALL);
        return this.updateShape(pLevel, pState, pPos, pSecondState, flag, flag1, flag2, flag3);
    }

    private BlockState sideUpdate(LevelReader pLevel, BlockPos pFirstPos, BlockState pFirstState, BlockPos pSecondPos, BlockState pSecondState, Direction pDir) {
        Direction direction = pDir.m_122424_();
        boolean flag = pDir == Direction.NORTH ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : JWallBlock.isConnected(pFirstState, NORTH_WALL);
        boolean flag1 = pDir == Direction.EAST ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : JWallBlock.isConnected(pFirstState, EAST_WALL);
        boolean flag2 = pDir == Direction.SOUTH ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : JWallBlock.isConnected(pFirstState, SOUTH_WALL);
        boolean flag3 = pDir == Direction.WEST ? this.connectsTo(pSecondState, pSecondState.m_60783_((BlockGetter)pLevel, pSecondPos, direction), direction) : JWallBlock.isConnected(pFirstState, WEST_WALL);
        BlockPos blockpos = pFirstPos.m_7494_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        return this.updateShape(pLevel, pFirstState, blockpos, blockstate, flag, flag1, flag2, flag3);
    }

    private BlockState updateShape(LevelReader pLevel, BlockState pState, BlockPos pPos, BlockState pNeighbour, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection) {
        VoxelShape voxelshape = pNeighbour.m_60812_((BlockGetter)pLevel, pPos).m_83263_(Direction.DOWN);
        BlockState blockstate = this.updateSides(pState, pNorthConnection, pEastConnection, pSouthConnection, pWestConnection, voxelshape);
        return (BlockState)blockstate.m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.shouldRaisePost(blockstate, pNeighbour, voxelshape)));
    }

    private boolean shouldRaisePost(BlockState pState, BlockState pNeighbour, VoxelShape pShape) {
        boolean flag6;
        boolean flag5;
        boolean flag;
        boolean bl = flag = pNeighbour.m_60734_() instanceof WallBlock && (Boolean)pNeighbour.m_61143_((Property)UP) != false;
        if (flag) {
            return true;
        }
        WallSide wallside = (WallSide)pState.m_61143_(NORTH_WALL);
        WallSide wallside1 = (WallSide)pState.m_61143_(SOUTH_WALL);
        WallSide wallside2 = (WallSide)pState.m_61143_(EAST_WALL);
        WallSide wallside3 = (WallSide)pState.m_61143_(WEST_WALL);
        boolean flag1 = wallside1 == WallSide.NONE;
        boolean flag2 = wallside3 == WallSide.NONE;
        boolean flag3 = wallside2 == WallSide.NONE;
        boolean flag4 = wallside == WallSide.NONE;
        boolean bl2 = flag5 = flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
        if (flag5) {
            return true;
        }
        boolean bl3 = flag6 = wallside == WallSide.TALL && wallside1 == WallSide.TALL || wallside2 == WallSide.TALL && wallside3 == WallSide.TALL;
        if (flag6) {
            return false;
        }
        return pNeighbour.m_204336_(BlockTags.f_13081_) || JWallBlock.isCovered(pShape, POST_TEST);
    }

    private BlockState updateSides(BlockState pState, boolean pNorthConnection, boolean pEastConnection, boolean pSouthConnection, boolean pWestConnection, VoxelShape pWallShape) {
        return (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_(NORTH_WALL, (Comparable)this.makeWallState(pNorthConnection, pWallShape, NORTH_TEST))).m_61124_(EAST_WALL, (Comparable)this.makeWallState(pEastConnection, pWallShape, EAST_TEST))).m_61124_(SOUTH_WALL, (Comparable)this.makeWallState(pSouthConnection, pWallShape, SOUTH_TEST))).m_61124_(WEST_WALL, (Comparable)this.makeWallState(pWestConnection, pWallShape, WEST_TEST));
    }

    private WallSide makeWallState(boolean pAllowConnection, VoxelShape pShape, VoxelShape pNeighbourShape) {
        if (pAllowConnection) {
            return JWallBlock.isCovered(pShape, pNeighbourShape) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    @NotNull
    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7420_(BlockState pState, @NotNull BlockGetter pReader, @NotNull BlockPos pPos) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{UP, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED});
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState pState, Rotation pRotation) {
        return switch (pRotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_(NORTH_WALL, (Comparable)((WallSide)pState.m_61143_(SOUTH_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)pState.m_61143_(WEST_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)pState.m_61143_(NORTH_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)pState.m_61143_(EAST_WALL)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_(NORTH_WALL, (Comparable)((WallSide)pState.m_61143_(EAST_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)pState.m_61143_(SOUTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)pState.m_61143_(WEST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)pState.m_61143_(NORTH_WALL)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_(NORTH_WALL, (Comparable)((WallSide)pState.m_61143_(WEST_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)pState.m_61143_(NORTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)pState.m_61143_(EAST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)pState.m_61143_(SOUTH_WALL)));
            default -> pState;
        };
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState pState, Mirror pMirror) {
        return switch (pMirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)pState.m_61124_(NORTH_WALL, (Comparable)((WallSide)pState.m_61143_(SOUTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)pState.m_61143_(NORTH_WALL)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)pState.m_61124_(EAST_WALL, (Comparable)((WallSide)pState.m_61143_(WEST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)pState.m_61143_(EAST_WALL)));
            default -> super.m_6943_(pState, pMirror);
        };
    }
}

