/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.crop.bushs;

import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class BradberryBushBlock
extends BushBlock
implements BonemealableBlock {
    private static final double HURT_SPEED_THRESHOLD = (double)0.003f;
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.f_61407_;
    private static final VoxelShape SAPLING_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public BradberryBushBlock(BlockBehaviour.Properties p) {
        super(p);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)JItems.BRADBERRY.get());
    }

    @NotNull
    public VoxelShape m_5940_(BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        if ((Integer)pState.m_61143_((Property)AGE) == 0) {
            return SAPLING_SHAPE;
        }
        return (Integer)pState.m_61143_((Property)AGE) < 3 ? MID_GROWTH_SHAPE : super.m_5940_(pState, pLevel, pPos, pContext);
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE) < 3;
    }

    public void m_213898_(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        int i = (Integer)pState.m_61143_((Property)AGE);
        if (i < 3 && pLevel.m_45524_(pPos.m_7494_(), 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (pRandom.m_188503_(5) == 0 ? 1 : 0) != 0)) {
            BlockState blockstate = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            pLevel.m_7731_(pPos, blockstate, 2);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)blockstate));
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public void m_7892_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Entity pEntity) {
        if (pEntity instanceof LivingEntity && pEntity.m_6095_() != EntityType.f_20452_ && pEntity.m_6095_() != EntityType.f_20550_) {
            pEntity.m_7601_(pState, new Vec3((double)0.8f, 0.75, (double)0.8f));
            if (!(pLevel.f_46443_ || (Integer)pState.m_61143_((Property)AGE) <= 0 || pEntity.f_19790_ == pEntity.m_20185_() && pEntity.f_19792_ == pEntity.m_20189_())) {
                double d0 = Math.abs(pEntity.m_20185_() - pEntity.f_19790_);
                double d1 = Math.abs(pEntity.m_20189_() - pEntity.f_19792_);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    // empty if block
                }
            }
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        boolean flag;
        int i = (Integer)pState.m_61143_((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && pPlayer.m_21120_(pHand).m_150930_(Items.f_42499_)) {
            return InteractionResult.PASS;
        }
        if (i > 1) {
            int j = 1 + pLevel.f_46441_.m_188503_(2);
            BradberryBushBlock.m_49840_((Level)pLevel, (BlockPos)pPos, (ItemStack)new ItemStack((ItemLike)JItems.BRADBERRY.get(), j + (flag ? 1 : 0)));
            pLevel.m_5594_(null, pPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + pLevel.f_46441_.m_188501_() * 0.4f);
            BlockState blockstate = (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1));
            pLevel.m_7731_(pPos, blockstate, 2);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)blockstate));
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean isC) {
        return (Integer)pState.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(@NotNull Level pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, BlockState pState) {
        int i = Math.min(3, (Integer)pState.m_61143_((Property)AGE) + 1);
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }
}

