/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.jitl.common.block.BitterwoodCampfireBlock;
import net.jitl.core.init.internal.JBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class BitterwoodCampfireBlockEntity
extends BlockEntity
implements Clearable {
    private static final int BURN_COOL_SPEED = 2;
    private static final int NUM_SLOTS = 4;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final int[] cookingProgress = new int[4];
    private final int[] cookingTime = new int[4];
    private final RecipeManager.CachedCheck<Container, CampfireCookingRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44111_);

    public BitterwoodCampfireBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)JBlockEntities.BITTERWOOD_CAMPFIRE.get(), pPos, pBlockState);
    }

    public static void cookTick(Level pLevel, BlockPos pPos, BlockState pState, BitterwoodCampfireBlockEntity pBlockEntity) {
        boolean flag = false;
        for (int i = 0; i < pBlockEntity.items.size(); ++i) {
            SimpleContainer container;
            ItemStack itemstack1;
            ItemStack itemstack = (ItemStack)pBlockEntity.items.get(i);
            if (itemstack.m_41619_()) continue;
            flag = true;
            int n = i;
            pBlockEntity.cookingProgress[n] = pBlockEntity.cookingProgress[n] + 1;
            if (pBlockEntity.cookingProgress[i] < pBlockEntity.cookingTime[i] || !(itemstack1 = pBlockEntity.quickCheck.m_213657_((Container)(container = new SimpleContainer(new ItemStack[]{itemstack})), pLevel).map(arg_0 -> BitterwoodCampfireBlockEntity.lambda$cookTick$0((Container)container, pLevel, arg_0)).orElse(itemstack)).m_246617_(pLevel.m_246046_())) continue;
            Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)itemstack1);
            pBlockEntity.items.set(i, (Object)ItemStack.f_41583_);
            pLevel.m_7260_(pPos, pState, pState, 3);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)pState));
        }
        if (flag) {
            BitterwoodCampfireBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static void cooldownTick(Level pLevel, BlockPos pPos, BlockState pState, BitterwoodCampfireBlockEntity pBlockEntity) {
        boolean flag = false;
        for (int i = 0; i < pBlockEntity.items.size(); ++i) {
            if (pBlockEntity.cookingProgress[i] <= 0) continue;
            flag = true;
            pBlockEntity.cookingProgress[i] = Mth.m_14045_((int)(pBlockEntity.cookingProgress[i] - 2), (int)0, (int)pBlockEntity.cookingTime[i]);
        }
        if (flag) {
            BitterwoodCampfireBlockEntity.m_155232_((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public static void particleTick(Level pLevel, BlockPos pPos, BlockState pState, BitterwoodCampfireBlockEntity pBlockEntity) {
        RandomSource randomsource = pLevel.f_46441_;
        if (randomsource.m_188501_() < 0.11f) {
            for (int i = 0; i < randomsource.m_188503_(2) + 2; ++i) {
                BitterwoodCampfireBlock.m_51251_((Level)pLevel, (BlockPos)pPos, (boolean)((Boolean)pState.m_61143_((Property)BitterwoodCampfireBlock.f_51228_)), (boolean)false);
            }
        }
        int l = ((Direction)pState.m_61143_((Property)BitterwoodCampfireBlock.f_51230_)).m_122416_();
        for (int j = 0; j < pBlockEntity.items.size(); ++j) {
            if (((ItemStack)pBlockEntity.items.get(j)).m_41619_() || !(randomsource.m_188501_() < 0.2f)) continue;
            Direction direction = Direction.m_122407_((int)Math.floorMod(j + l, 4));
            float f = 0.3125f;
            double d0 = (double)pPos.m_123341_() + 0.5 - (double)((float)direction.m_122429_() * 0.3125f) + (double)((float)direction.m_122427_().m_122429_() * 0.3125f);
            double d1 = (double)pPos.m_123342_() + 0.5;
            double d2 = (double)pPos.m_123343_() + 0.5 - (double)((float)direction.m_122431_() * 0.3125f) + (double)((float)direction.m_122427_().m_122431_() * 0.3125f);
            for (int k = 0; k < 4; ++k) {
                pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        if (pTag.m_128425_("CookingTimes", 11)) {
            int[] aint = pTag.m_128465_("CookingTimes");
            System.arraycopy(aint, 0, this.cookingProgress, 0, Math.min(this.cookingTime.length, aint.length));
        }
        if (pTag.m_128425_("CookingTotalTimes", 11)) {
            int[] aint1 = pTag.m_128465_("CookingTotalTimes");
            System.arraycopy(aint1, 0, this.cookingTime, 0, Math.min(this.cookingTime.length, aint1.length));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18976_((CompoundTag)pTag, this.items, (boolean)true);
        pTag.m_128385_("CookingTimes", this.cookingProgress);
        pTag.m_128385_("CookingTotalTimes", this.cookingTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundtag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)compoundtag, this.items, (boolean)true);
        return compoundtag;
    }

    public Optional<CampfireCookingRecipe> getCookableRecipe(ItemStack pStack) {
        return this.items.stream().noneMatch(ItemStack::m_41619_) ? Optional.empty() : this.quickCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{pStack}), this.f_58857_);
    }

    public boolean placeFood(@Nullable Entity pEntity, ItemStack pStack, int pCookTime) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (!itemstack.m_41619_()) continue;
            this.cookingTime[i] = pCookTime;
            this.cookingProgress[i] = 0;
            this.items.set(i, (Object)pStack.m_41620_(1));
            this.f_58857_.m_220407_(GameEvent.f_157792_, this.m_58899_(), GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)this.m_58900_()));
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        this.m_6596_();
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void dowse() {
        if (this.f_58857_ != null) {
            this.markUpdated();
        }
    }

    private static /* synthetic */ ItemStack lambda$cookTick$0(Container container, Level pLevel, CampfireCookingRecipe p_296955_) {
        return p_296955_.m_5874_(container, pLevel.m_9598_());
    }
}

