/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity;

import java.util.Objects;
import net.jitl.common.block.JChestBlock;
import net.jitl.core.init.internal.JBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class JChestBlockEntity
extends ChestBlockEntity {
    private final ChestLidController chestLidController = new ChestLidController();
    private LazyOptional<IItemHandlerModifiable> chestHandler;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(@NotNull Level level2, @NotNull BlockPos blockPos2, @NotNull BlockState blockState2) {
            JChestBlockEntity.m_155338_(level2, blockPos2, blockState2, SoundEvents.f_11749_);
        }

        protected void m_142289_(@NotNull Level level1, @NotNull BlockPos blockPos1, @NotNull BlockState blockState1) {
            JChestBlockEntity.m_155338_(level1, blockPos1, blockState1, SoundEvents.f_11747_);
        }

        protected void m_142148_(@NotNull Level level3, @NotNull BlockPos blockPos3, @NotNull BlockState blockState3, int i, int int1) {
            JChestBlockEntity.this.m_142151_(level3, blockPos3, blockState3, i, int1);
        }

        protected boolean m_142718_(Player player1) {
            if (!(player1.f_36096_ instanceof ChestMenu)) {
                return false;
            }
            Container container = ((ChestMenu)player1.f_36096_).m_39261_();
            return container == JChestBlockEntity.this || container instanceof CompoundContainer && ((CompoundContainer)container).m_18927_((Container)JChestBlockEntity.this);
        }
    };

    protected JChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public JChestBlockEntity(BlockPos worldPosition, BlockState blockState) {
        this((BlockEntityType)JBlockEntities.JCHEST.get(), worldPosition, blockState);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.m_6520_(NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_));
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)this.m_7086_());
        }
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)this.m_7086_());
        }
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, JChestBlockEntity blockEntity) {
        blockEntity.chestLidController.m_155374_();
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.chestLidController.m_155377_(type > 0);
            return true;
        }
        return super.m_7531_(id, type);
    }

    public void m_5856_(@NotNull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(@NotNull Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    public float m_6683_(float partialTicks) {
        return this.chestLidController.m_155375_(partialTicks);
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory player) {
        return ChestMenu.m_39237_((int)id, (Inventory)player, (Container)this);
    }

    public void m_155250_(@NotNull BlockState blockState) {
        super.m_155250_(blockState);
        if (this.chestHandler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.chestHandler;
            this.chestHandler = null;
            oldHandler.invalidate();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @NotNull
    private IItemHandlerModifiable createHandler() {
        BlockState state = this.m_58900_();
        if (!(state.m_60734_() instanceof JChestBlock)) {
            return new InvWrapper((Container)this);
        }
        Container inv = JChestBlock.getContainer((JChestBlock)state.m_60734_(), state, this.m_58904_(), this.m_58899_(), true);
        return new InvWrapper((Container)(inv == null ? this : inv));
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
            this.chestHandler = null;
        }
    }

    public void m_155350_() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
        }
    }

    private static void m_155338_(Level level, BlockPos pos, BlockState state, SoundEvent sound) {
        ChestType chesttype = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = (double)pos.m_123342_() + 0.5;
            double d2 = (double)pos.m_123343_() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ChestBlock.m_51584_((BlockState)state);
                d0 += (double)direction.m_122429_() * 0.5;
                d2 += (double)direction.m_122431_() * 0.5;
            }
            level.m_6263_(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }
}

