/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity;

import net.jitl.common.block.SenterianAltar;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.senterian.MiniSentryLord;
import net.jitl.common.entity.senterian.MiniSentryStalker;
import net.jitl.common.entity.senterian.MiniSentryWalker;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SenterianAltarTile
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int spawnTimer;
    public int spawnCount;
    private final RawAnimation ROTATE = RawAnimation.begin().thenLoop("animation.senterian_altar.active");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.senterian_altar.idle");

    public SenterianAltarTile(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)JBlockEntities.SENTERIAN_ALTAR.get(), pPos, pBlockState);
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("spawnTimer", 0);
        tag.m_128405_("spawnCount", 0);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.spawnTimer = tag.m_128451_("spawnTimer");
        this.spawnCount = tag.m_128451_("spawnCount");
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (((Boolean)((SenterianAltarTile)state.getAnimatable()).m_58900_().m_61143_((Property)SenterianAltar.IS_ACTIVE)).booleanValue()) {
                return state.setAndContinue(this.ROTATE);
            }
            return state.setAndContinue(this.IDLE);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SenterianAltarTile entity) {
        boolean isFull = (Boolean)state.m_61143_((Property)SenterianAltar.IS_ACTIVE);
        boolean isSpawning = (Boolean)state.m_61143_((Property)SenterianAltar.IS_SPAWNING);
        if (isFull) {
            if (entity.spawnTimer == 0) {
                entity.spawnTimer = 50;
                level.m_5594_(null, pos, (SoundEvent)JSounds.SENTRY_ALTAR_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (entity.spawnTimer == 5) {
                level.m_5594_(null, pos, (SoundEvent)JSounds.SENTRY_ALTAR_DEACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (entity.spawnTimer >= 0) {
                --entity.spawnTimer;
            }
            if (entity.spawnTimer <= 0) {
                entity.spawnTimer = 0;
            }
            if (entity.spawnTimer == 0) {
                entity.spawnMob(pos, level);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SenterianAltar.IS_SPAWNING, (Comparable)Boolean.valueOf(true)), 2);
                ++entity.spawnCount;
            }
            if (entity.spawnCount == 5) {
                entity.spawnCount = 0;
                level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)SenterianAltar.IS_ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SenterianAltar.IS_SPAWNING, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    private void spawnMob(BlockPos pos, Level level) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        JMonsterEntity mob = null;
        RandomSource random = RandomSource.m_216327_();
        switch (random.m_188503_(3)) {
            case 0: {
                JMonsterEntity jMonsterEntity = new MiniSentryLord((EntityType<? extends Monster>)((EntityType)JEntities.MINI_SENTRY_LORD_TYPE.get()), this.m_58904_());
                break;
            }
            case 1: {
                JMonsterEntity jMonsterEntity = new MiniSentryStalker((EntityType<? extends Monster>)((EntityType)JEntities.MINI_SENTRY_STALKER_TYPE.get()), this.m_58904_());
                break;
            }
            case 2: {
                JMonsterEntity jMonsterEntity = new MiniSentryWalker((EntityType<? extends Monster>)((EntityType)JEntities.MINI_SENTRY_WALKER_TYPE.get()), this.m_58904_());
                break;
            }
            default: {
                JMonsterEntity jMonsterEntity = mob = new MiniSentryLord((EntityType<? extends Monster>)((EntityType)JEntities.MINI_SENTRY_LORD_TYPE.get()), this.m_58904_());
            }
        }
        if (!level.f_46443_) {
            mob.m_6034_((float)x + 0.5f, (float)y + 1.0f, (float)z + 0.5f);
            level.m_7967_((Entity)mob);
        }
    }
}

