/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity;

import net.jitl.common.block.SummoningTableBlock;
import net.jitl.common.block.entity.container.SummoningTableContainer;
import net.jitl.core.helper.EnumSummoningRecipes;
import net.jitl.core.init.internal.JBlockEntities;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SummoningTableTile
extends RandomizableContainerBlockEntity
implements MenuProvider,
Nameable {
    public NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)7, (Object)ItemStack.f_41583_);

    public SummoningTableTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)JBlockEntities.SUMMONING_TABLE.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SummoningTableTile entity) {
        for (EnumSummoningRecipes summoningRecipes : EnumSummoningRecipes.values()) {
            entity.checkRecipeAndSummon(entity, summoningRecipes, state, level, pos);
        }
        if (entity.startedSummon()) {
            active_state = (BlockState)state.m_61124_((Property)SummoningTableBlock.IS_ACTIVE, (Comparable)Boolean.TRUE);
            level.m_7731_(pos, active_state, 2);
        } else {
            active_state = (BlockState)((BlockState)state.m_61124_((Property)SummoningTableBlock.IS_ACTIVE, (Comparable)Boolean.FALSE)).m_61124_((Property)SummoningTableBlock.SUMMON, (Comparable)Boolean.FALSE);
            level.m_7731_(pos, active_state, 2);
        }
    }

    public void checkRecipeAndSummon(SummoningTableTile entity, EnumSummoningRecipes recipe, BlockState state, Level level, BlockPos pos) {
        if (entity.areItemsInSlots(recipe.getItem(0), recipe.getItem(1), recipe.getItem(2), recipe.getItem(3), recipe.getItem(4), recipe.getItem(5), recipe.getItem(6))) {
            entity.summonItem(new ItemStack((ItemLike)recipe.getItem(7)));
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)SummoningTableBlock.SUMMON, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SummoningTableBlock.IS_ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public void summonItem(ItemStack orb) {
        ((ItemStack)this.inventory.get(0)).m_41774_(1);
        ((ItemStack)this.inventory.get(1)).m_41774_(1);
        ((ItemStack)this.inventory.get(2)).m_41774_(1);
        ((ItemStack)this.inventory.get(3)).m_41774_(1);
        ((ItemStack)this.inventory.get(4)).m_41774_(1);
        ((ItemStack)this.inventory.get(5)).m_41774_(1);
        ((ItemStack)this.inventory.get(6)).m_41774_(1);
        this.inventory.set(3, (Object)orb);
        assert (this.f_58857_ != null);
        this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)JSounds.EUCA_DISC_1.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ItemStack getItemInSlot(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public boolean areItemsInSlots(Item s, Item s1, Item s2, Item s3, Item s4, Item s5, Item s6) {
        return this.getItemInSlot(0).m_41720_() == s && this.getItemInSlot(1).m_41720_() == s1 && this.getItemInSlot(2).m_41720_() == s2 && this.getItemInSlot(3).m_41720_() == s3 && this.getItemInSlot(4).m_41720_() == s4 && this.getItemInSlot(5).m_41720_() == s5 && this.getItemInSlot(6).m_41720_() == s6;
    }

    public boolean startedSummon() {
        return this.getItemInSlot(0) != ItemStack.f_41583_ || this.getItemInSlot(1) != ItemStack.f_41583_ || this.getItemInSlot(2) != ItemStack.f_41583_ || this.getItemInSlot(3) != ItemStack.f_41583_ || this.getItemInSlot(4) != ItemStack.f_41583_ || this.getItemInSlot(5) != ItemStack.f_41583_ || this.getItemInSlot(6) != ItemStack.f_41583_;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.inventory);
    }

    @NotNull
    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(@NotNull NonNullList<ItemStack> item) {
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"jitl.tile.summon_table");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerID, @NotNull Inventory inventory) {
        return new SummoningTableContainer(containerID, inventory, (Container)this);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerID, Inventory inventory, Player player) {
        return new SummoningTableContainer(containerID, inventory, (Container)this);
    }

    public int m_6893_() {
        return 1;
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    @NotNull
    public ItemStack m_7407_(int pIndex, int pCount) {
        return ContainerHelper.m_18969_(this.inventory, (int)pIndex, (int)pCount);
    }

    @NotNull
    public ItemStack m_8016_(int pIndex) {
        return ContainerHelper.m_18966_(this.inventory, (int)pIndex);
    }

    public void m_6836_(int pIndex, ItemStack pStack) {
        this.inventory.set(pIndex, (Object)pStack);
        if (!this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.inventory.clear();
    }
}

