/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.entity.logic;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class DarkNotNeededSpawner
extends BaseSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int spawnDelay = 20;
    private SimpleWeightedRandomList<SpawnData> spawnPotentials = SimpleWeightedRandomList.m_185864_();
    @Nullable
    private SpawnData nextSpawnData;
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int spawnCount = 4;
    @Nullable
    private Entity displayEntity;
    private int maxNearbyEntities = 6;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;

    public void m_253197_(@NotNull EntityType<?> pType, @Nullable Level pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos) {
        this.m_253144_(pLevel, pRandom, pPos).m_186567_().m_128359_("id", BuiltInRegistries.f_256780_.m_7981_(pType).toString());
    }

    private boolean m_151343_(Level pLevel, BlockPos pPos) {
        return pLevel.m_45914_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, (double)this.requiredPlayerRange);
    }

    public void m_151319_(@NotNull Level pLevel, @NotNull BlockPos pPos) {
        if (!this.m_151343_(pLevel, pPos)) {
            this.oSpin = this.spin;
        } else if (this.displayEntity != null) {
            RandomSource randomsource = pLevel.m_213780_();
            double d0 = (double)pPos.m_123341_() + randomsource.m_188500_();
            double d1 = (double)pPos.m_123342_() + randomsource.m_188500_();
            double d2 = (double)pPos.m_123343_() + randomsource.m_188500_();
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.oSpin = this.spin;
            this.spin = (this.spin + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        }
    }

    public void m_151311_(@NotNull ServerLevel pServerLevel, @NotNull BlockPos pPos) {
        if (this.m_151343_((Level)pServerLevel, pPos)) {
            if (this.spawnDelay == -1) {
                this.m_151350_((Level)pServerLevel, pPos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                boolean flag = false;
                RandomSource randomsource = pServerLevel.m_213780_();
                SpawnData spawndata = this.m_253144_((Level)pServerLevel, randomsource, pPos);
                for (int i = 0; i < this.spawnCount; ++i) {
                    double d2;
                    CompoundTag compoundtag = spawndata.m_186567_();
                    Optional optional = EntityType.m_20637_((CompoundTag)compoundtag);
                    if (optional.isEmpty()) {
                        this.m_151350_((Level)pServerLevel, pPos);
                        return;
                    }
                    ListTag listtag = compoundtag.m_128437_("Pos", 6);
                    int j = listtag.size();
                    double d0 = j >= 1 ? listtag.m_128772_(0) : (double)pPos.m_123341_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.spawnRange + 0.5;
                    double d1 = j >= 2 ? listtag.m_128772_(1) : (double)(pPos.m_123342_() + randomsource.m_188503_(3) - 1);
                    double d = d2 = j >= 3 ? listtag.m_128772_(2) : (double)pPos.m_123343_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.spawnRange + 0.5;
                    if (!pServerLevel.m_45772_(((EntityType)optional.get()).m_20585_(d0, d1, d2))) continue;
                    BlockPos blockpos = BlockPos.m_274561_((double)d0, (double)d1, (double)d2);
                    if (spawndata.m_186574_().isPresent() && !((EntityType)optional.get()).m_20674_().m_21609_() && pServerLevel.m_46791_() == Difficulty.PEACEFUL) continue;
                    Entity entity = EntityType.m_20645_((CompoundTag)compoundtag, (Level)pServerLevel, p_151310_ -> {
                        p_151310_.m_7678_(d0, d1, d2, p_151310_.m_146908_(), p_151310_.m_146909_());
                        return p_151310_;
                    });
                    if (entity == null) {
                        this.m_151350_((Level)pServerLevel, pPos);
                        return;
                    }
                    int k = pServerLevel.m_45976_(entity.getClass(), new AABB((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (double)(pPos.m_123341_() + 1), (double)(pPos.m_123342_() + 1), (double)(pPos.m_123343_() + 1)).m_82400_((double)this.spawnRange)).size();
                    if (k >= this.maxNearbyEntities) {
                        this.m_151350_((Level)pServerLevel, pPos);
                        return;
                    }
                    entity.m_7678_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), randomsource.m_188501_() * 360.0f, 0.0f);
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        if (!mob.m_6914_((LevelReader)pServerLevel)) continue;
                        MobSpawnEvent.FinalizeSpawn event = ForgeEventFactory.onFinalizeSpawnSpawner((Mob)mob, (ServerLevelAccessor)pServerLevel, (DifficultyInstance)pServerLevel.m_6436_(entity.m_20183_()), null, (CompoundTag)compoundtag, (BaseSpawner)this);
                        if (event != null && spawndata.m_186567_().m_128440_() == 1 && spawndata.m_186567_().m_128425_("id", 8)) {
                            ((Mob)entity).m_6518_((ServerLevelAccessor)pServerLevel, event.getDifficulty(), event.getSpawnType(), event.getSpawnData(), event.getSpawnTag());
                        }
                    }
                    if (!pServerLevel.m_8860_(entity)) {
                        this.m_151350_((Level)pServerLevel, pPos);
                        return;
                    }
                    pServerLevel.m_46796_(2004, pPos, 0);
                    pServerLevel.m_142346_(entity, GameEvent.f_157810_, blockpos);
                    if (entity instanceof Mob) {
                        ((Mob)entity).m_21373_();
                    }
                    flag = true;
                }
                if (flag) {
                    this.m_151350_((Level)pServerLevel, pPos);
                }
            }
        }
    }

    private void m_151350_(Level pLevel, BlockPos pPos) {
        RandomSource randomsource = pLevel.f_46441_;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.m_188503_(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.m_216829_(randomsource).ifPresent(p_186386_ -> this.m_142667_(pLevel, pPos, (SpawnData)p_186386_.m_146310_()));
        this.m_142523_(pLevel, pPos, 1);
    }

    public void m_151328_(@Nullable Level pLevel, @NotNull BlockPos pPos, CompoundTag pTag) {
        boolean flag1;
        this.spawnDelay = pTag.m_128448_("Delay");
        boolean flag = pTag.m_128425_("SpawnData", 10);
        if (flag) {
            SpawnData spawndata = SpawnData.f_186559_.parse((DynamicOps)NbtOps.f_128958_, (Object)pTag.m_128469_("SpawnData")).resultOrPartial(p_186391_ -> LOGGER.warn("Invalid SpawnData: {}", p_186391_)).orElseGet(SpawnData::new);
            this.m_142667_(pLevel, pPos, spawndata);
        }
        if (flag1 = pTag.m_128425_("SpawnPotentials", 9)) {
            ListTag listtag = pTag.m_128437_("SpawnPotentials", 10);
            this.spawnPotentials = SpawnData.f_186560_.parse((DynamicOps)NbtOps.f_128958_, (Object)listtag).resultOrPartial(p_186388_ -> LOGGER.warn("Invalid SpawnPotentials list: {}", p_186388_)).orElseGet(SimpleWeightedRandomList::m_185864_);
        } else {
            this.spawnPotentials = SimpleWeightedRandomList.m_185862_((Object)(this.nextSpawnData != null ? this.nextSpawnData : new SpawnData()));
        }
        if (pTag.m_128425_("MinSpawnDelay", 99)) {
            this.minSpawnDelay = pTag.m_128448_("MinSpawnDelay");
            this.maxSpawnDelay = pTag.m_128448_("MaxSpawnDelay");
            this.spawnCount = pTag.m_128448_("SpawnCount");
        }
        if (pTag.m_128425_("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = pTag.m_128448_("MaxNearbyEntities");
            this.requiredPlayerRange = pTag.m_128448_("RequiredPlayerRange");
        }
        if (pTag.m_128425_("SpawnRange", 99)) {
            this.spawnRange = pTag.m_128448_("SpawnRange");
        }
        this.displayEntity = null;
    }

    @NotNull
    public CompoundTag m_186381_(CompoundTag pTag) {
        pTag.m_128376_("Delay", (short)this.spawnDelay);
        pTag.m_128376_("MinSpawnDelay", (short)this.minSpawnDelay);
        pTag.m_128376_("MaxSpawnDelay", (short)this.maxSpawnDelay);
        pTag.m_128376_("SpawnCount", (short)this.spawnCount);
        pTag.m_128376_("MaxNearbyEntities", (short)this.maxNearbyEntities);
        pTag.m_128376_("RequiredPlayerRange", (short)this.requiredPlayerRange);
        pTag.m_128376_("SpawnRange", (short)this.spawnRange);
        if (this.nextSpawnData != null) {
            pTag.m_128365_("SpawnData", (Tag)SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.nextSpawnData).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData")));
        }
        pTag.m_128365_("SpawnPotentials", (Tag)SpawnData.f_186560_.encodeStart((DynamicOps)NbtOps.f_128958_, this.spawnPotentials).result().orElseThrow());
        return pTag;
    }

    public boolean m_151316_(@NotNull Level pLevel, int pId) {
        if (pId == 1) {
            if (pLevel.f_46443_) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void m_142667_(@Nullable Level pLevel, @NotNull BlockPos pPos, @NotNull SpawnData pNextSpawnData) {
        this.nextSpawnData = pNextSpawnData;
    }

    private SpawnData m_253144_(@Nullable Level pLevel, RandomSource pRandom, BlockPos pPos) {
        if (this.nextSpawnData == null) {
            this.m_142667_(pLevel, pPos, this.spawnPotentials.m_216829_(pRandom).map(WeightedEntry.Wrapper::m_146310_).orElseGet(SpawnData::new));
        }
        return this.nextSpawnData;
    }

    public abstract void m_142523_(@NotNull Level var1, @NotNull BlockPos var2, int var3);

    public double m_45473_() {
        return this.spin;
    }

    public double m_45474_() {
        return this.oSpin;
    }

    @Nullable
    public Entity getSpawnerEntity() {
        return null;
    }

    @Nullable
    public BlockEntity getSpawnerBlockEntity() {
        return null;
    }
}

