/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.portal;

import net.jitl.common.capability.portal.PlayerPortalProvider;
import net.jitl.common.world.dimension.CorbaTeleporter;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;

public class CorbaPortalBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);

    public CorbaPortalBlock() {
        super(JBlockProperties.PORTAL);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    public void m_214162_(@NotNull BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        double d0 = (double)pPos.m_123341_() + pRandom.m_188500_();
        double d1 = (double)pPos.m_123342_() + 0.8;
        double d2 = (double)pPos.m_123343_() + pRandom.m_188500_();
        pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else {
                if (!entity.m_9236_().f_46443_ && !pos.equals((Object)entity.f_19819_)) {
                    entity.f_19819_ = pos.m_7949_();
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.getCapability(PlayerPortalProvider.PORTAL).ifPresent(stats -> {
                        stats.setInPortal(this, true);
                        int cooldownTime = stats.getPortalTimer();
                        if (cooldownTime >= player.m_6078_()) {
                            this.teleport(entity);
                            stats.setPortalTimer(0);
                        }
                    });
                } else {
                    this.teleport(entity);
                }
            }
        }
    }

    public void teleport(Entity entity) {
        Level entityWorld = entity.m_9236_();
        MinecraftServer minecraftserver = entityWorld.m_7654_();
        if (minecraftserver != null) {
            ResourceKey<Level> destination = entity.m_9236_().m_46472_() == Dimensions.CORBA ? Level.f_46428_ : Dimensions.CORBA;
            ServerLevel destinationWorld = minecraftserver.m_129880_(destination);
            ResourceKey poi = Dimensions.CORBA_PORTAL.getKey();
            if (destinationWorld != null && minecraftserver.m_7079_() && !entity.m_20159_()) {
                entity.m_20091_();
                entity.changeDimension(destinationWorld, (ITeleporter)new CorbaTeleporter(destinationWorld, this, (Block)JBlocks.CORBA_PORTAL_FRAME.get(), (ResourceKey<PoiType>)poi, destination));
            }
        }
    }

    public boolean m_5946_(@NotNull BlockState pState, @NotNull Fluid pFluid) {
        return false;
    }
}

