/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.block.portal;

import java.util.function.Supplier;
import net.jitl.common.capability.portal.PlayerPortalProvider;
import net.jitl.common.world.dimension.BaseTeleporter;
import net.jitl.common.world.dimension.Dimensions;
import net.jitl.core.init.internal.JBlockProperties;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBasePortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private final ResourceKey<Level> dimensionID;
    private final Supplier<Block> frame;

    public JBasePortalBlock(ResourceKey<Level> dimID, Supplier<Block> frame) {
        super(JBlockProperties.PORTAL);
        this.dimensionID = dimID;
        this.frame = frame;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Z: {
                return Z_AABB;
            }
        }
        return X_AABB;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        SimpleParticleType particle = null;
        SimpleParticleType particle2 = null;
        if (this == JBlocks.EUCA_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.GOLDITE_FLOWER.get();
        }
        if (this == JBlocks.FROZEN_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.SNOWFLAKE.get();
        }
        if (this == JBlocks.BOIL_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.FLAME_POLLEN.get();
            particle2 = (SimpleParticleType)JParticleManager.SULPHUR.get();
        }
        if (this == JBlocks.TERRANIAN_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.TERRANIA_PORTAL.get();
        }
        if (this == JBlocks.CLOUDIA_PORTAL.get()) {
            particle = (SimpleParticleType)JParticleManager.CLOUDIA_PORTAL.get();
        }
        for (int i = 0; i < 3; ++i) {
            double d0 = (double)pPos.m_123341_() + pRandom.m_188500_();
            double d1 = (double)pPos.m_123342_() + pRandom.m_188500_();
            double d2 = (double)pPos.m_123343_() + pRandom.m_188500_();
            double d3 = ((double)pRandom.m_188501_() - 0.5) * 0.5;
            double d4 = ((double)pRandom.m_188501_() - 0.5) * 0.5;
            double d5 = ((double)pRandom.m_188501_() - 0.5) * 0.5;
            int j = pRandom.m_188503_(2) * 2 - 1;
            if (!pLevel.m_8055_(pPos.m_122024_()).m_60713_((Block)this) && !pLevel.m_8055_(pPos.m_122029_()).m_60713_((Block)this)) {
                d0 = (double)pPos.m_123341_() + 0.5 + 0.25 * (double)j;
                d3 = pRandom.m_188501_() * 2.0f * (float)j;
            } else {
                d2 = (double)pPos.m_123343_() + 0.5 + 0.25 * (double)j;
                d5 = pRandom.m_188501_() * 2.0f * (float)j;
            }
            if (particle != null) {
                pLevel.m_7106_((ParticleOptions)particle, d0, d1, d2, d3, d4, d5);
            }
            if (particle2 == null) continue;
            pLevel.m_7106_((ParticleOptions)particle2, d0, d1, d2, d3, d4, d5);
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.m_122434_();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.m_61143_(AXIS);
        boolean flag = direction$axis1 != direction$axis && direction$axis.m_122479_();
        return !flag && facingState.m_60734_() != this && !new Size(worldIn, currentPos, direction$axis1, this).validatePortal() ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return ItemStack.f_41583_;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Direction.Axis.Z -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    case Direction.Axis.X -> (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    default -> state;
                };
            }
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        if (!entity.m_20159_() && !entity.m_20160_() && entity.m_6072_()) {
            if (entity.m_20092_()) {
                entity.m_20091_();
            } else {
                if (!entity.m_9236_().f_46443_ && !pos.equals((Object)entity.f_19819_)) {
                    entity.f_19819_ = pos.m_7949_();
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    player.getCapability(PlayerPortalProvider.PORTAL).ifPresent(stats -> {
                        stats.setInPortal(this, true);
                        int cooldownTime = stats.getPortalTimer();
                        if (cooldownTime >= player.m_6078_()) {
                            this.teleport(entity);
                            stats.setPortalTimer(0);
                        }
                    });
                } else {
                    this.teleport(entity);
                }
            }
        }
    }

    public void teleport(Entity entity) {
        Level entityWorld = entity.m_9236_();
        MinecraftServer minecraftserver = entityWorld.m_7654_();
        if (minecraftserver != null) {
            ResourceKey<Level> destination = entity.m_9236_().m_46472_() == this.dimensionID ? Level.f_46428_ : this.dimensionID;
            ServerLevel destinationWorld = minecraftserver.m_129880_(destination);
            ResourceKey poi = Dimensions.FROZEN_PORTAL.getKey();
            if (this == JBlocks.EUCA_PORTAL.get()) {
                poi = Dimensions.EUCA_PORTAL.getKey();
            }
            if (this == JBlocks.FROZEN_PORTAL.get()) {
                poi = Dimensions.FROZEN_PORTAL.getKey();
            }
            if (this == JBlocks.BOIL_PORTAL.get()) {
                poi = Dimensions.BOIL_PORTAL.getKey();
            }
            if (this == JBlocks.DEPTHS_PORTAL.get()) {
                poi = Dimensions.DEPTHS_PORTAL.getKey();
            }
            if (this == JBlocks.CORBA_PORTAL.get()) {
                poi = Dimensions.CORBA_PORTAL.getKey();
            }
            if (this == JBlocks.TERRANIAN_PORTAL.get()) {
                poi = Dimensions.TERRANIAN_PORTAL.getKey();
            }
            if (this == JBlocks.CLOUDIA_PORTAL.get()) {
                poi = Dimensions.CLOUDIA_PORTAL.getKey();
            }
            if (destinationWorld != null && minecraftserver.m_7079_() && !entity.m_20159_()) {
                entity.m_20091_();
                entity.changeDimension(destinationWorld, (ITeleporter)new BaseTeleporter(destinationWorld, this, this.frame.get(), (ResourceKey<PoiType>)poi, destination));
            }
        }
    }

    public boolean makePortal(LevelAccessor worldIn, BlockPos pos) {
        Size portal = this.isPortal(worldIn, pos);
        if (portal != null) {
            portal.createPortalBlocks();
            return true;
        }
        return false;
    }

    public Size isPortal(LevelAccessor worldIn, BlockPos pos) {
        Size portalX = new Size(worldIn, pos, Direction.Axis.X, this);
        if (portalX.isValid() && portalX.portalBlockCount == 0) {
            return portalX;
        }
        Size portalZ = new Size(worldIn, pos, Direction.Axis.Z, this);
        return portalZ.isValid() && portalZ.portalBlockCount == 0 ? portalZ : null;
    }

    public static class Size {
        private final LevelAccessor world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;
        private final Block portal;

        public Size(LevelAccessor worldIn, BlockPos pos, Direction.Axis axisIn, Block portal) {
            this.world = worldIn;
            this.axis = axisIn;
            this.portal = portal;
            if (axisIn == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            int i = this.getDistanceUntilEdge(pos, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = pos.m_5484_(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos pos, Direction directionIn) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.canConnect(this.world.m_8055_(blockpos = pos.m_5484_(directionIn, i))) && this.world.m_8055_(blockpos.m_7495_()).m_60734_() == this.world.m_8055_(pos.m_7495_()).m_60734_(); ++i) {
            }
            BlockPos framePos = pos.m_5484_(directionIn, i);
            return this.world.m_8055_(framePos).m_60734_() == this.world.m_8055_(pos.m_7495_()).m_60734_() ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos framePos;
                    assert (this.bottomLeft != null);
                    BlockPos blockpos = this.bottomLeft.m_5484_(this.rightDir, i).m_6630_(this.height);
                    BlockState blockstate = this.world.m_8055_(blockpos);
                    if (!this.canConnect(blockstate)) break block0;
                    Block block = blockstate.m_60734_();
                    if (block == this.portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? this.world.m_8055_(framePos = blockpos.m_121945_(this.leftDir)).m_60734_() != this.world.m_8055_(framePos).m_60734_() : i == this.width - 1 && this.world.m_8055_(framePos = blockpos.m_121945_(this.rightDir)).m_60734_() != this.world.m_8055_(framePos).m_60734_()) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                BlockPos framePos = this.bottomLeft.m_5484_(this.rightDir, j).m_6630_(this.height);
                if (this.world.m_8055_(framePos).m_60734_() == this.world.m_8055_(framePos).m_60734_()) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean canConnect(BlockState pos) {
            Block block = pos.m_60734_();
            return pos.m_60795_() || block == this.portal;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void createPortalBlocks() {
            BlockState blockstate = (BlockState)this.portal.m_49966_().m_61124_(AXIS, (Comparable)this.axis);
            assert (this.bottomLeft != null);
            BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(pos -> this.world.m_7731_(pos, blockstate, 18));
        }

        private boolean isPortalCountValidForSize() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean validatePortal() {
            return this.isValid() && this.isPortalCountValidForSize();
        }
    }
}

