/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.capability.essence;

import java.util.Objects;
import net.jitl.core.data.JNetworkRegistry;
import net.jitl.core.init.internal.JAttributes;
import net.jitl.core.network.PacketEssenceBar;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;

public class PlayerEssence {
    private float currentEssence;
    private float burnoutTime;
    private int timeout;

    public void copyFrom(PlayerEssence source) {
        this.currentEssence = source.currentEssence;
    }

    public float getCurrentEssence() {
        return this.currentEssence;
    }

    public static float getMaxEssence(Player player) {
        return (float)Objects.requireNonNull(player.m_21051_((Attribute)JAttributes.MAX_ESSENCE.get())).m_22135_();
    }

    public void setBurnout(float value) {
        this.burnoutTime = Math.max(value, 0.0f);
    }

    public void setTimeout(int value) {
        this.timeout = value;
    }

    public float getBurnout() {
        return this.burnoutTime;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setEssence(float value) {
        if (this.getCurrentEssence() != value) {
            this.currentEssence = value;
        }
    }

    public boolean isRegenReady() {
        if (this.getTimeout() <= 0) {
            return this.getBurnout() <= 0.0f;
        }
        this.setTimeout(this.getTimeout() - 1);
        return false;
    }

    public void addEssence(Player player, float add) {
        this.setEssence(Math.min(this.getCurrentEssence() + add, PlayerEssence.getMaxEssence(player)));
    }

    public boolean consumeEssence(Player player, float price) {
        if (!player.m_7500_()) {
            if (this.hasEssence(price)) {
                this.setEssence(this.getCurrentEssence() - price);
                this.setTimeout(20);
                return true;
            }
            float attributeValue = (float)player.m_21051_((Attribute)JAttributes.ESSENCE_BURNOUT.get()).m_22135_();
            this.setBurnout(Math.min(this.getBurnout() + attributeValue, attributeValue * 5.0f));
            return false;
        }
        return true;
    }

    public boolean hasEssence(float price) {
        return this.getCurrentEssence() >= price;
    }

    public boolean checkEssenceEitherSide(boolean client, Player player, float price) {
        if (client) {
            return player.m_7500_() || this.hasEssence(price);
        }
        return this.consumeEssence(player, price);
    }

    public void saveNBT(CompoundTag nbt) {
        nbt.m_128350_("essence", this.currentEssence);
        nbt.m_128350_("burnoutTime", this.burnoutTime);
        nbt.m_128405_("timeout", this.timeout);
    }

    public void readNBT(CompoundTag nbt) {
        this.currentEssence = nbt.m_128457_("essence");
        this.burnoutTime = nbt.m_128457_("burnoutTime");
        this.timeout = nbt.m_128451_("timeout");
    }

    public void sendPacket(Player player) {
        if (player instanceof ServerPlayer) {
            JNetworkRegistry.INSTANCE.sendTo((Object)new PacketEssenceBar(this), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

