/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.capability.gear;

import net.jitl.common.capability.gear.PlayerArmor;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerArmorProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PlayerArmor> PLAYER_ARMOR = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerArmor>(){});
    private PlayerArmor playerArmor = null;
    private final LazyOptional<PlayerArmor> optional = LazyOptional.of(this::createPlayerArmor);

    @NotNull
    private PlayerArmor createPlayerArmor() {
        if (this.playerArmor == null) {
            this.playerArmor = new PlayerArmor();
        }
        return this.playerArmor;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == PLAYER_ARMOR) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createPlayerArmor().saveNBT(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.createPlayerArmor().readNBT(nbt);
    }
}

