/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.capability.keypressed;

import net.jitl.common.capability.keypressed.PressedKeyCap;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PressedKeyCapProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static Capability<PressedKeyCap> PRESSED_KEY_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<PressedKeyCap>(){});
    private PressedKeyCap keyCap = null;
    private final LazyOptional<PressedKeyCap> optional = LazyOptional.of(this::createPressedKeyCap);

    @NotNull
    private PressedKeyCap createPressedKeyCap() {
        if (this.keyCap == null) {
            this.keyCap = new PressedKeyCap();
        }
        return this.keyCap;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == PRESSED_KEY_CAP) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.createPressedKeyCap().saveNBT(tag);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.createPressedKeyCap().readNBT(nbt);
    }
}

