/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.capability.portal;

import net.jitl.client.util.ClientTools;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PlayerPortal {
    private float portalOverlayTime = 0.0f;
    private float oldPortalOverlayTime = 0.0f;
    private Block portalBlockToRender = Blocks.f_50016_;
    private int portalTimer = 0;
    private boolean inPortal = false;

    public void copyFrom(PlayerPortal source) {
        this.portalOverlayTime = source.portalOverlayTime;
        this.oldPortalOverlayTime = source.oldPortalOverlayTime;
        this.portalBlockToRender = source.portalBlockToRender;
        this.portalTimer = source.portalTimer;
        this.inPortal = source.inPortal;
    }

    public void setInPortal(Block portal, boolean inPortal) {
        this.portalBlockToRender = portal;
        this.inPortal = inPortal;
    }

    public void serverTick() {
        this.oldPortalOverlayTime = this.portalOverlayTime;
        float alphaTime = 0.01f;
        if (this.inPortal) {
            ++this.portalTimer;
            this.portalOverlayTime += alphaTime;
            if (this.portalOverlayTime > 1.0f) {
                this.portalOverlayTime = 1.0f;
            }
            this.inPortal = false;
        } else {
            if (this.portalOverlayTime > 0.0f) {
                this.portalOverlayTime -= 0.05f;
            }
            if (this.portalOverlayTime < 0.0f) {
                this.portalOverlayTime = 0.0f;
            }
            if (this.portalTimer > 0) {
                this.portalTimer -= 4;
            }
        }
    }

    public void clientTick() {
        if (this.portalOverlayTime == 0.01f) {
            if (this.getPortalBlockToRender() == JBlocks.TERRANIAN_PORTAL.get()) {
                ClientTools.playLocalSound(SoundEvents.f_12288_, 1.0f, 0.65f);
            }
            if (this.getPortalBlockToRender() == JBlocks.EUCA_PORTAL.get()) {
                ClientTools.playLocalSound(JSounds.EUCA_PORTAL, 1.0f, 0.65f);
            }
            if (this.getPortalBlockToRender() == JBlocks.FROZEN_PORTAL.get()) {
                ClientTools.playLocalSound(JSounds.FROZEN_PORTAL, 1.0f, 0.65f);
            }
            if (this.getPortalBlockToRender() == JBlocks.BOIL_PORTAL.get()) {
                ClientTools.playLocalSound(JSounds.BOIL_PORTAL, 1.0f, 0.65f);
            }
            if (this.getPortalBlockToRender() == JBlocks.DEPTHS_PORTAL.get()) {
                ClientTools.playLocalSound(JSounds.DEPTHS_PORTAL, 1.0f, 0.65f);
            }
            if (this.getPortalBlockToRender() == JBlocks.CORBA_PORTAL.get()) {
                ClientTools.playLocalSound(JSounds.CORBA_PORTAL, 1.0f, 0.65f);
            }
            if (this.getPortalBlockToRender() == JBlocks.CLOUDIA_PORTAL.get()) {
                ClientTools.playLocalSound(JSounds.CLOUDIA_PORTAL, 1.0f, 0.65f);
            }
            if (this.getPortalBlockToRender() == JBlocks.SENTERIAN_PORTAL.get()) {
                ClientTools.playLocalSound(JSounds.SENTERIAN_PORTAL, 1.0f, 0.65f);
            }
        }
    }

    public Block getPortalBlockToRender() {
        return this.portalBlockToRender;
    }

    public void setPortalTimer(int timer) {
        this.portalTimer = timer;
    }

    public int getPortalTimer() {
        return this.portalTimer;
    }

    public float getPortalOverlayTime() {
        return this.portalOverlayTime;
    }

    public float getOldPortalOverlayTime() {
        return this.oldPortalOverlayTime;
    }

    public void saveNBT(CompoundTag nbt) {
        nbt.m_128350_("portalOverlayTime", this.portalOverlayTime);
        nbt.m_128350_("oldPortalOverlayTime", this.oldPortalOverlayTime);
        nbt.m_128405_("portalTimer", this.portalTimer);
        nbt.m_128379_("inPortal", this.inPortal);
    }

    public void readNBT(CompoundTag nbt) {
        this.portalOverlayTime = nbt.m_128457_("portalOverlayTime");
        this.oldPortalOverlayTime = nbt.m_128457_("oldPortalOverlayTime");
        this.portalTimer = nbt.m_128451_("portalTimer");
        this.inPortal = nbt.m_128471_("inPortal");
    }
}

