/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.capability.stats;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.client.stats.PacketPlayerStats;
import net.jitl.core.data.JNetworkRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;

public class PlayerStats {
    private boolean hasBlizzard;
    private int sentacoins;
    private int overworldLevel;
    private int netherLevel;
    private int endLevel;
    private int eucaLevel;
    private int boilLevel;
    private int frozenLevel;
    private int depthsLevel;
    private int corbaLevel;
    private int cloudiaLevel;
    private int terraniaLevel;
    private int senterianLevel;
    private float overworldXP;
    private float netherXP;
    private float endXP;
    private float eucaXP;
    private float boilXP;
    private float frozenXP;
    private float depthsXP;
    private float corbaXP;
    private float cloudiaXP;
    private float terraniaXP;
    private float senterianXP;

    public void copyFrom(PlayerStats stats) {
        this.hasBlizzard = stats.hasBlizzard;
        for (EnumKnowledge k : EnumKnowledge.values()) {
            this.setLevel(k, stats.getLevel(k));
            this.setXP(k, stats.getXP(k));
        }
    }

    public boolean hasBlizzard() {
        return this.hasBlizzard;
    }

    public void setBlizzard(boolean blizzard) {
        this.hasBlizzard = blizzard;
    }

    public int getSentacoins() {
        return this.sentacoins;
    }

    public void setSentacoins(int value) {
        this.sentacoins = value;
    }

    public boolean useSentacoins(int amount) {
        if (this.sentacoins >= amount) {
            this.sentacoins -= amount;
            return true;
        }
        return false;
    }

    public void addSentacoins(int amount) {
        this.sentacoins += amount;
    }

    public int getLevel(EnumKnowledge knowledge) {
        int level = 0;
        switch (knowledge) {
            case OVERWORLD: {
                level = this.overworldLevel;
                break;
            }
            case NETHER: {
                level = this.netherLevel;
                break;
            }
            case END: {
                level = this.endLevel;
                break;
            }
            case EUCA: {
                level = this.eucaLevel;
                break;
            }
            case BOIL: {
                level = this.boilLevel;
                break;
            }
            case FROZEN: {
                level = this.frozenLevel;
                break;
            }
            case DEPTHS: {
                level = this.depthsLevel;
                break;
            }
            case CORBA: {
                level = this.corbaLevel;
                break;
            }
            case CLOUDIA: {
                level = this.cloudiaLevel;
                break;
            }
            case TERRANIA: {
                level = this.terraniaLevel;
                break;
            }
            case SENTERIAN: {
                level = this.senterianLevel;
            }
        }
        return level;
    }

    public void addLevel(EnumKnowledge knowledge, int level) {
        switch (knowledge) {
            case OVERWORLD: {
                this.overworldLevel += level;
                break;
            }
            case NETHER: {
                this.netherLevel += level;
                break;
            }
            case END: {
                this.endLevel += level;
                break;
            }
            case EUCA: {
                this.eucaLevel += level;
                break;
            }
            case BOIL: {
                this.boilLevel += level;
                break;
            }
            case FROZEN: {
                this.frozenLevel += level;
                break;
            }
            case DEPTHS: {
                this.depthsLevel += level;
                break;
            }
            case CORBA: {
                this.corbaLevel += level;
                break;
            }
            case CLOUDIA: {
                this.cloudiaLevel += level;
                break;
            }
            case TERRANIA: {
                this.terraniaLevel += level;
                break;
            }
            case SENTERIAN: {
                this.senterianLevel += level;
            }
        }
    }

    public void setLevel(EnumKnowledge knowledge, int level) {
        switch (knowledge) {
            case OVERWORLD: {
                this.overworldLevel = level;
                break;
            }
            case NETHER: {
                this.netherLevel = level;
                break;
            }
            case END: {
                this.endLevel = level;
                break;
            }
            case EUCA: {
                this.eucaLevel = level;
                break;
            }
            case BOIL: {
                this.boilLevel = level;
                break;
            }
            case FROZEN: {
                this.frozenLevel = level;
                break;
            }
            case DEPTHS: {
                this.depthsLevel = level;
                break;
            }
            case CORBA: {
                this.corbaLevel = level;
                break;
            }
            case CLOUDIA: {
                this.cloudiaLevel = level;
                break;
            }
            case TERRANIA: {
                this.terraniaLevel = level;
                break;
            }
            case SENTERIAN: {
                this.senterianLevel = level;
            }
        }
    }

    public void setXP(EnumKnowledge knowledge, float amount) {
        switch (knowledge) {
            case OVERWORLD: {
                this.overworldXP = amount;
                break;
            }
            case NETHER: {
                this.netherXP = amount;
                break;
            }
            case END: {
                this.endXP = amount;
                break;
            }
            case EUCA: {
                this.eucaXP = amount;
                break;
            }
            case BOIL: {
                this.boilXP = amount;
                break;
            }
            case FROZEN: {
                this.frozenXP = amount;
                break;
            }
            case DEPTHS: {
                this.depthsXP = amount;
                break;
            }
            case CORBA: {
                this.corbaXP = amount;
                break;
            }
            case CLOUDIA: {
                this.cloudiaXP = amount;
                break;
            }
            case TERRANIA: {
                this.terraniaXP = amount;
                break;
            }
            case SENTERIAN: {
                this.senterianXP = amount;
            }
        }
    }

    public float getXP(EnumKnowledge knowledge) {
        float XP = 0.0f;
        switch (knowledge) {
            case OVERWORLD: {
                XP = this.overworldXP;
                break;
            }
            case NETHER: {
                XP = this.netherXP;
                break;
            }
            case END: {
                XP = this.endXP;
                break;
            }
            case EUCA: {
                XP = this.eucaXP;
                break;
            }
            case BOIL: {
                XP = this.boilXP;
                break;
            }
            case FROZEN: {
                XP = this.frozenXP;
                break;
            }
            case DEPTHS: {
                XP = this.depthsXP;
                break;
            }
            case CORBA: {
                XP = this.corbaXP;
                break;
            }
            case CLOUDIA: {
                XP = this.cloudiaXP;
                break;
            }
            case TERRANIA: {
                XP = this.terraniaXP;
                break;
            }
            case SENTERIAN: {
                XP = this.senterianXP;
            }
        }
        return XP;
    }

    public void addXP(EnumKnowledge knowledge, float amount, Player player) {
        if (this.getXP(knowledge) + amount >= this.getLevelCapacity(this.getLevel(knowledge))) {
            this.setXP(knowledge, this.getXP(knowledge) + amount - this.getLevelCapacity(this.getLevel(knowledge)));
            this.addLevel(knowledge, 1);
        } else {
            this.setXP(knowledge, this.getXP(knowledge) + amount);
        }
        this.sendPacket(knowledge, player);
    }

    public float getTotal(EnumKnowledge knowledge) {
        float amount = 0.0f;
        for (int i = 0; i < this.getLevel(knowledge); ++i) {
            amount += this.getLevelCapacity(this.getLevel(knowledge));
        }
        return amount + this.getXP(knowledge);
    }

    public float remove(EnumKnowledge knowledge, float amount) {
        float total = this.getTotal(knowledge);
        if (amount > total) {
            float left = amount - total;
            this.setLevel(knowledge, 0);
            this.setXP(knowledge, 0.0f);
            return left;
        }
        if (this.getXP(knowledge) - amount < 0.0f) {
            amount -= this.getXP(knowledge);
            while (amount > 0.0f) {
                float levelCapacity = this.getLevelCapacity(this.getLevel(knowledge));
                if (levelCapacity > amount) {
                    this.setLevel(knowledge, this.getLevel(knowledge) - 1);
                    this.setXP(knowledge, levelCapacity - amount);
                    return 0.0f;
                }
                amount -= levelCapacity;
                this.setLevel(knowledge, this.getLevel(knowledge) - 1);
            }
            throw new IllegalStateException("This shouldn't be achieved, because if all levels' at capacity is smaller than removed amount, it should be cut in the start of the method");
        }
        this.setXP(knowledge, this.getXP(knowledge) - amount);
        return 0.0f;
    }

    public void sendPacket(EnumKnowledge k, Player player) {
        if (player instanceof ServerPlayer) {
            JNetworkRegistry.INSTANCE.sendTo((Object)new PacketPlayerStats(k, this), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public void update(Player player) {
        for (EnumKnowledge k : EnumKnowledge.values()) {
            if (this.getLevel(k) >= 100) {
                this.setLevel(k, 100);
                this.setXP(k, 0.0f);
            }
            this.sendPacket(k, player);
        }
    }

    public boolean isCompleted(EnumKnowledge k) {
        return this.getLevel(k) >= 100;
    }

    public float getLevelCapacity(int level) {
        return level >= 5 ? 50.0f : (level >= 10 ? 70.0f : (level >= 15 ? 90.0f : (level >= 20 ? 110.0f : (level >= 30 ? 130.0f : (level >= 40 ? 150.0f : 30.0f)))));
    }

    public void saveNBT(CompoundTag tag) {
        tag.m_128379_("hasBlizzard", this.hasBlizzard);
        tag.m_128405_("sentacoins", this.sentacoins);
        tag.m_128405_("overworld_level", this.overworldLevel);
        tag.m_128405_("nether_level", this.netherLevel);
        tag.m_128405_("end_level", this.endLevel);
        tag.m_128405_("euca_level", this.eucaLevel);
        tag.m_128405_("boil_level", this.boilLevel);
        tag.m_128405_("frozen_level", this.frozenLevel);
        tag.m_128405_("depths_level", this.depthsLevel);
        tag.m_128405_("corba_level", this.corbaLevel);
        tag.m_128405_("cloudia_level", this.cloudiaLevel);
        tag.m_128405_("terrania_level", this.terraniaLevel);
        tag.m_128405_("senterian_level", this.senterianLevel);
        tag.m_128350_("overworld_xp", this.overworldXP);
        tag.m_128350_("nether_xp", this.netherXP);
        tag.m_128350_("end_xp", this.endXP);
        tag.m_128350_("euca_xp", this.eucaXP);
        tag.m_128350_("boil_xp", this.boilXP);
        tag.m_128350_("frozen_xp", this.frozenXP);
        tag.m_128350_("depths_xp", this.depthsXP);
        tag.m_128350_("corba_xp", this.corbaXP);
        tag.m_128350_("cloudia_xp", this.cloudiaXP);
        tag.m_128350_("terrania_xp", this.terraniaXP);
        tag.m_128350_("senterian_xp", this.senterianXP);
    }

    public void readNBT(CompoundTag tag) {
        this.hasBlizzard = tag.m_128471_("hasBlizzard");
        this.sentacoins = tag.m_128451_("sentacoins");
        this.overworldLevel = tag.m_128451_("overworld_level");
        this.netherLevel = tag.m_128451_("nether_level");
        this.endLevel = tag.m_128451_("end_level");
        this.eucaLevel = tag.m_128451_("euca_level");
        this.boilLevel = tag.m_128451_("boil_level");
        this.frozenLevel = tag.m_128451_("frozen_level");
        this.depthsLevel = tag.m_128451_("depths_level");
        this.corbaLevel = tag.m_128451_("corba_level");
        this.cloudiaLevel = tag.m_128451_("cloudia_level");
        this.terraniaLevel = tag.m_128451_("terrania_level");
        this.senterianLevel = tag.m_128451_("senterian_level");
        this.overworldXP = tag.m_128457_("overworld_xp");
        this.netherXP = tag.m_128457_("nether_xp");
        this.endXP = tag.m_128457_("end_xp");
        this.eucaXP = tag.m_128457_("euca_xp");
        this.boilXP = tag.m_128457_("boil_xp");
        this.frozenXP = tag.m_128457_("frozen_xp");
        this.depthsXP = tag.m_128457_("depths_xp");
        this.corbaXP = tag.m_128457_("corba_xp");
        this.cloudiaXP = tag.m_128457_("cloudia_xp");
        this.terraniaXP = tag.m_128457_("terrania_xp");
        this.senterianXP = tag.m_128457_("senterian_xp");
    }
}

