/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import java.util.Objects;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.capability.stats.PlayerStatsProvider;
import net.jitl.common.entity.base.IDontAttackWhenPeaceful;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JBossEntity
extends JMonsterEntity
implements IDontAttackWhenPeaceful {
    private final ServerBossEvent BOSS_INFO = (ServerBossEvent)new ServerBossEvent(Objects.requireNonNull(this.m_5446_()), BossEvent.BossBarColor.PINK, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(false).m_7006_(false);
    protected EnumKnowledge knowledge;
    protected int knowledgeLevel = 0;

    protected JBossEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.BOSS_INFO.f_18847_ = this.m_20148_();
    }

    protected boolean m_8028_() {
        return false;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)JSounds.BOSS_DEATH.get();
    }

    public float m_6121_() {
        return 10.0f;
    }

    protected abstract BossCrystal.Type getDeathCrystalType();

    public abstract ResourceLocation lootTable();

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.BOSS_INFO.m_6456_(Objects.requireNonNull(this.m_5446_()));
        }
        this.BOSS_INFO.f_18847_ = this.m_20148_();
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.BOSS_INFO.m_6456_(Objects.requireNonNull(this.m_5446_()));
    }

    protected void m_8024_() {
        super.m_8024_();
        this.BOSS_INFO.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        if (this.showBarWhenSpawned()) {
            this.BOSS_INFO.m_6543_(player);
        }
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.BOSS_INFO.m_6539_(player);
    }

    public abstract boolean showBarWhenSpawned();

    public boolean m_6469_(@NotNull DamageSource d, float f) {
        if (!this.m_9236_().m_5776_() && !this.showBarWhenSpawned() && d.m_7639_() instanceof Player) {
            AABB axisalignedbb = AABB.m_82333_((Vec3)this.m_20182_()).m_82400_(10.0);
            for (Player player : this.m_9236_().m_45976_(Player.class, axisalignedbb)) {
                this.BOSS_INFO.m_6543_((ServerPlayer)player);
            }
        }
        return super.m_6469_(d, f);
    }

    public void setKnowledge(EnumKnowledge knowledge, int level) {
        this.knowledge = knowledge;
        this.knowledgeLevel = level;
    }

    @Override
    public void m_6667_(@NotNull DamageSource s) {
        super.m_6667_(s);
        Entity entity = s.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.knowledge != null) {
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(knowledge -> knowledge.addLevel(this.knowledge, this.knowledgeLevel));
            }
        }
        if (!this.m_9236_().m_5776_()) {
            BossCrystal crystal = new BossCrystal((EntityType<? extends BossCrystal>)((EntityType)JEntities.BOSS_CRYSTAL_TYPE.get()), this.m_9236_(), this.getDeathCrystalType(), this.lootTable());
            crystal.m_146884_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
            this.m_9236_().m_7967_((Entity)crystal);
        }
    }
}

