/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import java.util.EnumSet;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.capability.stats.PlayerStatsProvider;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class JFlyingEntity
extends FlyingMob
implements Enemy,
GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private double speed = 0.3;
    protected EnumKnowledge knowledge;
    protected float knowledgeAmount = 0.0f;

    public JFlyingEntity(EntityType<? extends JFlyingEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new MoveHelperController(this);
    }

    public void setKnowledge(EnumKnowledge knowledge, float amount) {
        this.knowledge = knowledge;
        this.knowledgeAmount = amount;
    }

    protected abstract void controller(AnimatableManager.ControllerRegistrar var1);

    public boolean m_5545_(LevelAccessor level, @NotNull MobSpawnType type) {
        return !level.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_MUSHROOM) && !level.m_204166_(this.m_20183_()).m_203565_(Biomes.f_220594_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.controller(controllers);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setFlyingSpeed(double speed) {
        this.speed = speed;
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        Entity entity = cause.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.knowledge != null) {
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(knowledge -> knowledge.addXP(this.knowledge, this.knowledgeAmount, player));
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFlyGoal(this, this.speed));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.addGoals();
    }

    public abstract void addGoals();

    protected boolean m_8028_() {
        return this.despawnInPeaceful();
    }

    public abstract boolean despawnInPeaceful();

    static class MoveHelperController
    extends MoveControl {
        private final JFlyingEntity entity;
        private int floatDuration;

        public MoveHelperController(JFlyingEntity entity) {
            super((Mob)entity);
            this.entity = entity;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.entity.m_217043_().m_188503_(3) + 1;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.entity.m_20185_(), this.f_24976_ - this.entity.m_20186_(), this.f_24977_ - this.entity.m_20189_());
                double d0 = vector3d.m_82553_();
                if (this.canReach(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.entity.m_20256_(this.entity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 vector3d_, int int_) {
            AABB a = this.entity.m_20191_();
            for (int i = 1; i < int_; ++i) {
                a = a.m_82383_(vector3d_);
                if (this.entity.m_9236_().m_45756_((Entity)this.entity, a)) continue;
                return false;
            }
            return true;
        }
    }

    static class RandomFlyGoal
    extends Goal {
        private final JFlyingEntity entity;
        public final double speed;

        public RandomFlyGoal(JFlyingEntity entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl m = this.entity.m_21566_();
            if (!m.m_24995_()) {
                return true;
            }
            double d0 = m.m_25000_() - this.entity.m_20185_();
            double d3 = d0 * d0 + (d1 = m.m_25001_() - this.entity.m_20186_()) * d1 + (d2 = m.m_25002_() - this.entity.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.entity.m_217043_();
            double d0 = this.entity.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.entity.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.entity.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.entity.m_21566_().m_6849_(d0, d1, d2, this.speed);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final JFlyingEntity entity;

        public LookAroundGoal(JFlyingEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            Vec3 vector3d = this.entity.m_20184_();
            this.entity.m_146922_(-((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f);
            this.entity.f_20883_ = this.entity.m_146908_();
        }
    }
}

