/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import java.util.Objects;
import java.util.UUID;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.capability.stats.PlayerStatsProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class JTamableEntity
extends TamableAnimal
implements NeutralMob,
GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(JTamableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    protected EnumKnowledge knowledge;
    protected float knowledgeAmount = 0.0f;
    protected boolean addKnowledgeWhenTame = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected JTamableEntity(EntityType<? extends JTamableEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_7105_(false);
    }

    protected boolean m_8028_() {
        return !this.m_21824_();
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType type) {
        return !level.m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_MUSHROOM) && !level.m_204166_(this.m_20183_()).m_203565_(Biomes.f_220594_);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setKnowledge(EnumKnowledge knowledge, float amount, boolean addKnowledgeWhenTame) {
        this.knowledge = knowledge;
        this.knowledgeAmount = amount;
        this.addKnowledgeWhenTame = addKnowledgeWhenTame;
    }

    public void setKnowledge(EnumKnowledge knowledge, float amount) {
        this.knowledge = knowledge;
        this.knowledgeAmount = amount;
        this.addKnowledgeWhenTame = false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((JTamableEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.m_21678_(pCompound);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
        Entity entity = cause.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.knowledge != null) {
                player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(knowledge -> knowledge.addXP(this.knowledge, this.knowledgeAmount, player));
            }
        }
    }

    public void m_7105_(boolean pTamed) {
        super.m_7105_(pTamed);
        if (pTamed) {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)this.setTameHealth());
            this.m_21153_(this.setTameHealth());
        } else {
            Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)this.setBaseHealth());
        }
    }

    protected abstract void controller(AnimatableManager.ControllerRegistrar var1);

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.controller(controllers);
    }

    public abstract int setBaseHealth();

    public abstract int setTameHealth();

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!this.m_9236_().f_46443_ || this.m_6162_() && this.m_6898_(itemstack)) {
            if (this.m_21824_()) {
                if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float f = foodproperties != null ? (float)foodproperties.m_38744_() : 1.0f;
                    this.m_5634_(2.0f * f);
                    itemstack.m_41774_(1);
                    this.m_146850_(GameEvent.f_157806_);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                }
                InteractionResult interactionresult = super.m_6071_(pPlayer, pHand);
                if (!interactionresult.m_19077_() && this.m_21830_((LivingEntity)pPlayer)) {
                    this.m_21839_(!this.m_21827_());
                    this.f_20899_ = false;
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    return InteractionResult.SUCCESS;
                }
                return interactionresult;
            }
            if (itemstack.m_150930_(this.getTameItem()) && !this.m_21660_()) {
                itemstack.m_41774_(1);
                this.tryToTame(pPlayer);
                return InteractionResult.SUCCESS;
            }
            return super.m_6071_(pPlayer, pHand);
        }
        boolean flag = this.m_21830_((LivingEntity)pPlayer) || this.m_21824_() || itemstack.m_150930_(Items.f_42500_) && !this.m_21824_() && !this.m_21660_();
        return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
    }

    public abstract Item getTameItem();

    private void tryToTame(Player pPlayer) {
        if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
            this.m_21828_(pPlayer);
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            this.m_21839_(true);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            if (this.knowledge != null) {
                pPlayer.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(knowledge -> knowledge.addXP(this.knowledge, this.knowledgeAmount * 2.0f, pPlayer));
            }
        } else {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        }
    }

    public boolean m_6898_(ItemStack s) {
        return s.m_150930_(this.getTameItem());
    }

    public int m_5792_() {
        return 8;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @javax.annotation.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@javax.annotation.Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public boolean m_7757_(@NotNull LivingEntity pTarget, @NotNull LivingEntity pOwner) {
        TamableAnimal tamableanimal;
        if (pTarget instanceof Creeper || pTarget instanceof Ghast || pTarget instanceof ArmorStand) {
            return false;
        }
        if (pTarget instanceof JTamableEntity) {
            JTamableEntity e = (JTamableEntity)pTarget;
            return !e.m_21824_() || e.m_269323_() != pOwner;
        }
        if (pTarget instanceof Player) {
            Player player1;
            Player player = (Player)pTarget;
            if (pOwner instanceof Player && !(player1 = (Player)pOwner).m_7099_(player)) {
                return false;
            }
        }
        return !(pTarget instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)pTarget).m_21824_();
    }

    public boolean m_6573_(@NotNull Player pPlayer) {
        return !this.m_21660_() && super.m_6573_(pPlayer);
    }

    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }
}

