/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.base;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import net.jitl.common.entity.base.JPathfinderMob;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class JVillagerEntity
extends JPathfinderMob
implements Npc,
Merchant,
Enemy,
GeoEntity {
    private Player playerEntity;
    protected MerchantOffers offers;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public JVillagerEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    public void m_7189_(@Nullable Player player) {
        this.playerEntity = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.playerEntity;
    }

    @NotNull
    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.provideTrades();
        }
        return this.offers;
    }

    @Override
    protected abstract void controller(AnimatableManager.ControllerRegistrar var1);

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        this.controller(controllers);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    protected abstract Int2ObjectMap<VillagerTrades.ItemListing[]> getVillagerTrades();

    protected void provideTrades() {
        VillagerTrades.ItemListing[] trades = (VillagerTrades.ItemListing[])Objects.requireNonNull(this.getVillagerTrades()).get(1);
        if (trades != null) {
            MerchantOffers merchantOffers = this.m_6616_();
            this.addTrades(merchantOffers, trades);
        }
    }

    protected void addTrades(MerchantOffers offers, VillagerTrades.ItemListing[] trades) {
        HashSet set = Sets.newHashSet();
        for (int i = 0; i < trades.length; ++i) {
            set.add(i);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int int1 = (Integer)iterator.next();
            VillagerTrades.ItemListing villagerTrades = trades[int1];
            MerchantOffer merchantoffer = villagerTrades.m_213663_((Entity)this, this.f_19796_);
            if (merchantoffer == null) continue;
            offers.add((Object)merchantoffer);
        }
    }

    public void m_6255_(@Nullable MerchantOffers offers) {
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
        if (offer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            double y = this.m_20186_() + (double)(this.m_20206_() / 2.0f);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), y, this.m_20189_(), i));
        }
    }

    public void trade(Player playerEntity) {
        if (!this.m_6616_().isEmpty() && !this.m_9236_().m_5776_()) {
            this.m_7189_(playerEntity);
            this.m_45301_(playerEntity, this.m_5446_(), 1);
        }
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player playerEntity, @NotNull InteractionHand playerHand) {
        if (!this.m_6084_() || this.playerEntity != null || !this.canTrade()) {
            return super.m_6071_(playerEntity, playerHand);
        }
        this.trade(playerEntity);
        return super.m_6071_(playerEntity, playerHand);
    }

    public boolean canTrade() {
        return true;
    }

    public void m_7713_(@NotNull ItemStack stack) {
    }

    @NotNull
    public Level getLevel() {
        return this.m_9236_();
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xpIn) {
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return null;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_183595_() {
        return this.getLevel().f_46443_;
    }
}

