/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import java.util.EnumSet;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JBossEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.common.entity.goal.AttackWhenDifficultGoal;
import net.jitl.common.entity.goal.IdleHealGoal;
import net.jitl.common.entity.nether.InfernoBlaze;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JLootTables;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Blazier
extends JBossEntity {
    private int spawnTimer;
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.blazier.idle");

    public Blazier(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.spawnTimer = 0;
        this.setKnowledge(EnumKnowledge.NETHER, 10);
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new BlazierAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new IdleHealGoal((Mob)this, 4800));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new AttackWhenDifficultGoal((Mob)this, this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)JSounds.BLAZIER_IDLE.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)JSounds.BLAZIER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)JSounds.BLAZIER_HURT.get();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21223_() <= 250.0f) {
            if (this.spawnTimer == 0 && !this.m_9236_().m_5776_()) {
                InfernoBlaze z = new InfernoBlaze((EntityType<? extends Monster>)((EntityType)JEntities.INFERNO_BLAZE_TYPE.get()), this.m_9236_());
                double posX = this.m_20182_().f_82479_;
                double posY = this.m_20182_().f_82480_;
                double posZ = this.m_20182_().f_82481_;
                z.m_6034_(posX + 3.0, posY, posZ);
                InfernoBlaze z1 = new InfernoBlaze((EntityType<? extends Monster>)((EntityType)JEntities.INFERNO_BLAZE_TYPE.get()), this.m_9236_());
                z1.m_6034_(posX - 3.0, posY, posZ);
                InfernoBlaze z2 = new InfernoBlaze((EntityType<? extends Monster>)((EntityType)JEntities.INFERNO_BLAZE_TYPE.get()), this.m_9236_());
                z2.m_6034_(posX, posY, posZ + 3.0);
                InfernoBlaze z3 = new InfernoBlaze((EntityType<? extends Monster>)((EntityType)JEntities.INFERNO_BLAZE_TYPE.get()), this.m_9236_());
                z3.m_6034_(posX, posY, posZ - 3.0);
                this.m_9236_().m_7967_((Entity)z);
                this.m_9236_().m_7967_((Entity)z1);
                this.m_9236_().m_7967_((Entity)z2);
                this.m_9236_().m_7967_((Entity)z3);
                this.spawnTimer = 500;
            }
            --this.spawnTimer;
        }
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 850.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> state.setAndContinue(this.IDLE))});
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
    }

    @Override
    @Nullable
    protected BossCrystal.Type getDeathCrystalType() {
        return BossCrystal.Type.NETHER;
    }

    @Override
    public ResourceLocation lootTable() {
        return JLootTables.BLAZIER_CRYSTAL;
    }

    @Override
    public boolean showBarWhenSpawned() {
        return true;
    }

    public float m_213856_() {
        return 1.0f;
    }

    static class BlazierAttackGoal
    extends Goal {
        private final Blazier blazier;
        private int attackStep;
        private int attackTime;
        private int lastSeen;

        public BlazierAttackGoal(Blazier blazier) {
            this.blazier = blazier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.blazier.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.blazier.m_6779_(livingentity);
        }

        public void m_8056_() {
            this.attackStep = 0;
        }

        public void m_8041_() {
            this.lastSeen = 0;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            --this.attackTime;
            LivingEntity livingentity = this.blazier.m_5448_();
            if (livingentity != null) {
                boolean flag = this.blazier.m_21574_().m_148306_((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.blazier.m_20280_((Entity)livingentity);
                if (d0 < 4.0) {
                    if (!flag) {
                        return;
                    }
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blazier.m_7327_((Entity)livingentity);
                    }
                    this.blazier.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() && flag) {
                    double d1 = livingentity.m_20185_() - this.blazier.m_20185_();
                    double d2 = livingentity.m_20227_(0.5) - this.blazier.m_20227_(0.5);
                    double d3 = livingentity.m_20189_() - this.blazier.m_20189_();
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 60;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 6;
                        } else {
                            this.attackTime = 100;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            if (!this.blazier.m_20067_()) {
                                this.blazier.m_9236_().m_5898_(null, 1018, this.blazier.m_20183_(), 0);
                            }
                            for (int i = 0; i < 1; ++i) {
                                LargeFireball fireball = new LargeFireball(this.blazier.m_9236_(), (LivingEntity)this.blazier, this.blazier.m_217043_().m_216328_(d1, 2.297 * d4), d2, this.blazier.m_217043_().m_216328_(d3, 2.297 * d4), 1);
                                fireball.m_6034_(fireball.m_20185_(), this.blazier.m_20227_(0.5) + 0.5, fireball.m_20189_());
                                this.blazier.m_9236_().m_7967_((Entity)fireball);
                            }
                        }
                    }
                    this.blazier.m_21563_().m_24960_((Entity)livingentity, 10.0f, 10.0f);
                } else if (this.lastSeen < 5) {
                    this.blazier.m_21566_().m_6849_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_(), 1.0);
                }
                super.m_8037_();
            }
        }

        private double getFollowDistance() {
            return this.blazier.m_21133_(Attributes.f_22277_);
        }
    }
}

