/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Objects;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BossCrystal
extends Mob
implements GeoEntity {
    private final NonNullList<ItemStack> storedItems = NonNullList.m_122779_();
    private ResourceLocation loot_table;
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(BossCrystal.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.bosscrystal.idle");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BossCrystal(EntityType<? extends BossCrystal> pEntityType, Level pLevel, Type t, ResourceLocation loot) {
        this(pEntityType, pLevel);
        this.setType(t.getName());
        this.setLootTable(loot);
        this.m_20334_(0.0, 0.0, 0.0);
    }

    public BossCrystal(EntityType<? extends BossCrystal> entityEntityType, Level level) {
        super(entityEntityType, level);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_(Attributes.f_22279_, 0.0).m_22265_();
    }

    public void m_8107_() {
        for (int i = 0; i < 1; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)"type");
    }

    public String getCrystalType() {
        return (String)this.f_19804_.m_135370_(TYPE);
    }

    public void setType(String t) {
        this.f_19804_.m_135381_(TYPE, (Object)t);
    }

    public void setLootTable(ResourceLocation table) {
        this.loot_table = table;
    }

    public void m_7378_(CompoundTag compound) {
        ContainerHelper.m_18980_((CompoundTag)compound, this.storedItems);
        this.setType(compound.m_128461_("type"));
    }

    public void m_7380_(CompoundTag compound) {
        ContainerHelper.m_18973_((CompoundTag)compound, this.storedItems);
        compound.m_128359_("type", this.getCrystalType());
    }

    public boolean m_5829_() {
        return true;
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            LootTable table = Objects.requireNonNull(this.m_9236_().m_7654_()).m_278653_().m_278676_(this.loot_table);
            ObjectArrayList itemList = table.m_287195_(new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81416_));
            this.storedItems.addAll((Collection)itemList);
            for (ItemStack storedItem : this.storedItems) {
                ItemStack item = new ItemStack((ItemLike)storedItem.m_41720_());
                item.m_41764_(storedItem.m_41613_());
                ItemEntity entity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)entity);
            }
            this.m_5496_((SoundEvent)JSounds.CRYSTAL_PICKUP.get(), 1.0f, 1.0f);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_7337_(Entity e) {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public void m_7334_(Entity entity) {
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public ResourceLocation getTexture() {
        return JITL.rl("textures/entity/crystal/" + this.getCrystalType() + ".png");
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> state.setAndContinue(this.IDLE))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum Type {
        COMMON("common"),
        NETHER("nether"),
        BOIL("boil"),
        EUCA("euca"),
        DEPTHS("depths"),
        CORBA("corba"),
        TERRANIA("terrania"),
        CLOUDIA("cloudia"),
        SENTERIAN("senterian"),
        FROZEN("frozen");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

