/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JBossEntity;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.common.entity.goal.AttackWhenDifficultGoal;
import net.jitl.common.entity.goal.IdleHealGoal;
import net.jitl.core.init.internal.JLootTables;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class FrostGolem
extends JBossEntity {
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.frost_golem.walk");
    private final RawAnimation ATTACK = RawAnimation.begin().thenLoop("animation.frost_golem.swing");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.frost_golem.idle");

    public FrostGolem(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.FROZEN, 10);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new JMonsterEntity.AnimatedAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(1, (Goal)new IdleHealGoal((Mob)this, 4800));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new AttackWhenDifficultGoal((Mob)this, this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12058_;
    }

    public boolean m_7327_(Entity entity) {
        this.m_9236_().m_7605_((Entity)this, (byte)1);
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (int)damage > 0 ? damage / 2.0f + (float)this.f_19796_.m_188503_((int)damage) : damage;
        boolean hurt = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f1);
        if (hurt) {
            entity.m_20256_(entity.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
            this.m_19970_((LivingEntity)this, entity);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return hurt;
    }

    public void m_7822_(byte id) {
        if (id == 1) {
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        }
        super.m_7822_(id);
    }

    @Override
    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 350.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 3.0).m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isAttacking()) {
                return state.setAndContinue(this.ATTACK);
            }
            return state.setAndContinue(this.IDLE);
        })});
    }

    @Override
    @Nullable
    protected BossCrystal.Type getDeathCrystalType() {
        return BossCrystal.Type.FROZEN;
    }

    @Override
    public ResourceLocation lootTable() {
        return JLootTables.FROST_GOLEM_CRYSTAL;
    }

    @Override
    public boolean showBarWhenSpawned() {
        return false;
    }
}

