/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JFlyingBossEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.common.entity.goal.AttackWhenDifficultGoal;
import net.jitl.core.init.internal.JLootTables;
import net.jitl.core.init.internal.JParticleManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Scale
extends JFlyingBossEntity {
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(Scale.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.scale.idle");

    public Scale(EntityType<? extends Scale> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setFlyingSpeed(0.2);
        this.setKnowledge(EnumKnowledge.DEPTHS, 10);
    }

    @Override
    public void addGoals() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new ShootFireballGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new AttackWhenDifficultGoal((Mob)this, this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12554_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12557_;
    }

    @Override
    public boolean despawnInPeaceful() {
        return false;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1550.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 80.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            for (int i = 0; i < 6; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)JParticleManager.CRYSTAL_FRUIT.get(), this.m_20182_().f_82479_ + (this.f_19796_.m_188500_() - 0.5), this.m_20182_().f_82480_ + this.f_19796_.m_188500_(), this.m_20182_().f_82481_ + (this.f_19796_.m_188500_() - 0.5), (this.f_19796_.m_188500_() - 0.5) * 2.0, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 2.0);
            }
        }
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> state.setAndContinue(this.IDLE))});
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
    }

    @Override
    @Nullable
    protected BossCrystal.Type getDeathCrystalType() {
        return BossCrystal.Type.DEPTHS;
    }

    @Override
    public ResourceLocation lootTable() {
        return JLootTables.SCALE_CRYSTAL;
    }

    @Override
    public boolean showBarWhenSpawned() {
        return true;
    }

    public void setCharging(boolean pCharging) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)pCharging);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
    }

    public static class ShootFireballGoal
    extends Goal {
        private final Scale scale;
        public int chargeTime;

        public ShootFireballGoal(Scale pscale) {
            this.scale = pscale;
        }

        public boolean m_8036_() {
            return this.scale.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
            this.scale.setCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.scale.m_5448_();
            if (livingentity != null) {
                if (livingentity.m_20280_((Entity)this.scale) < 4096.0 && this.scale.m_142582_((Entity)livingentity)) {
                    Level level = this.scale.m_9236_();
                    ++this.chargeTime;
                    if (this.chargeTime == 10 && !this.scale.m_20067_()) {
                        level.m_5898_((Player)null, 1015, this.scale.m_20183_(), 0);
                    }
                    if (this.chargeTime == 20) {
                        Vec3 vec3 = this.scale.m_20252_(1.0f);
                        double d2 = livingentity.m_20185_() - (this.scale.m_20185_() + vec3.f_82479_ * 4.0);
                        double d3 = livingentity.m_20227_(0.5) - (0.5 + this.scale.m_20227_(0.5));
                        double d4 = livingentity.m_20189_() - (this.scale.m_20189_() + vec3.f_82481_ * 4.0);
                        if (!this.scale.m_20067_()) {
                            level.m_5898_(null, 1016, this.scale.m_20183_(), 0);
                        }
                        SmallFireball fireball = new SmallFireball(level, (LivingEntity)this.scale, d2, d3, d4);
                        fireball.m_6034_(this.scale.m_20185_() + vec3.f_82479_ * 4.0, this.scale.m_20227_(0.5) + 0.5, fireball.m_20189_() + vec3.f_82481_ * 4.0);
                        level.m_7967_((Entity)fireball);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.scale.setCharging(this.chargeTime > 10);
            }
        }
    }
}

