/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JBossEntity;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.common.entity.goal.AttackWhenDifficultGoal;
import net.jitl.common.entity.goal.IdleHealGoal;
import net.jitl.core.helper.JMusic;
import net.jitl.core.init.internal.JLootTables;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class TowerGuardian
extends JBossEntity {
    private static final JMusic BOSS_TRACK = new JMusic((SoundEvent)JSounds.TEMPLE_GUARDIAN_MUSIC.get(), 2, 0, 0);
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.tower_guardian.walk");
    private final RawAnimation ATTACK = RawAnimation.begin().thenLoop("animation.tower_guardian.smash");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.tower_guardian.idle");

    public TowerGuardian(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.OVERWORLD, 5);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new JMonsterEntity.AnimatedAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new IdleHealGoal((Mob)this, 1200));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new AttackWhenDifficultGoal((Mob)this, this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12554_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.ROCK.get();
    }

    public boolean m_7327_(Entity entity) {
        this.m_9236_().m_7605_((Entity)this, (byte)1);
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float explosionRadius = 3.0f;
        double particleWidth = 4.0;
        Vec3 vec3 = this.m_20184_();
        float f1 = (int)damage > 0 ? damage / 2.0f + (float)this.f_19796_.m_188503_((int)damage) : damage;
        boolean hurt = entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f1);
        int x = Mth.m_14107_((double)entity.m_20185_());
        int y = Mth.m_14107_((double)(entity.m_20186_() - (double)0.2f));
        int z = Mth.m_14107_((double)entity.m_20189_());
        BlockPos blockpos = new BlockPos(x, y, z);
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (hurt) {
            if (this.f_19796_.m_188503_(15) == 0) {
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), explosionRadius, Level.ExplosionInteraction.NONE);
            }
            if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 50; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(blockpos), this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * particleWidth, this.m_20186_() + 0.1, this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * particleWidth, vec3.f_82479_ * -4.0, 1.5, vec3.f_82481_ * -4.0);
                }
            }
            this.m_19970_((LivingEntity)this, entity);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return hurt;
    }

    public void m_7822_(byte id) {
        if (id == 1) {
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        }
        super.m_7822_(id);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 275.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 2.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.1).m_22265_();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isAttacking()) {
                return state.setAndContinue(this.ATTACK);
            }
            return state.setAndContinue(this.IDLE);
        })});
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
    }

    @Override
    @Nullable
    protected BossCrystal.Type getDeathCrystalType() {
        return BossCrystal.Type.COMMON;
    }

    @Override
    public ResourceLocation lootTable() {
        return JLootTables.TOWER_GUARDIAN_CRYSTAL;
    }

    @Override
    public boolean showBarWhenSpawned() {
        return false;
    }
}

