/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.boss;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JBossEntity;
import net.jitl.common.entity.boss.BossCrystal;
import net.jitl.common.entity.goal.AttackWhenDifficultGoal;
import net.jitl.common.entity.goal.IdleHealGoal;
import net.jitl.core.init.internal.JLootTables;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class WitheringBeast
extends JBossEntity
implements RangedAttackMob {
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.withering_beast.idle");
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.withering_beast.walk");

    public WitheringBeast(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.NETHER, 10);
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 20.0f));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new IdleHealGoal((Mob)this, 4800));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new AttackWhenDifficultGoal((Mob)this, this));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, null));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12554_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_12557_;
    }

    private double getHeadX(int pHead) {
        if (pHead <= 0) {
            return this.m_20185_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14089_((float)f);
        return this.m_20185_() + (double)f1 * 1.3;
    }

    private double getHeadY(int pHead) {
        return pHead <= 0 ? this.m_20186_() + 3.0 : this.m_20186_() + 2.2;
    }

    private double getHeadZ(int pHead) {
        if (pHead <= 0) {
            return this.m_20189_();
        }
        float f = (this.f_20883_ + (float)(180 * (pHead - 1))) * ((float)Math.PI / 180);
        float f1 = Mth.m_14031_((float)f);
        return this.m_20189_() + (double)f1 * 1.3;
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        this.performRangedAttack(0, pTarget.m_20185_(), pTarget.m_20186_() + (double)pTarget.m_20192_() * 0.5, pTarget.m_20189_(), this.f_19796_.m_188501_() < 0.001f);
    }

    private void performRangedAttack(int pHead, double pX, double pY, double pZ, boolean pIsDangerous) {
        if (!this.m_20067_()) {
            this.m_9236_().m_5898_(null, 1024, this.m_20183_(), 0);
        }
        double d0 = this.getHeadX(pHead);
        double d1 = this.getHeadY(pHead);
        double d2 = this.getHeadZ(pHead);
        double d3 = pX - d0;
        double d4 = pY - d1;
        double d5 = pZ - d2;
        WitherSkull witherskull = new WitherSkull(this.m_9236_(), (LivingEntity)this, d3, d4, d5);
        witherskull.m_5602_((Entity)this);
        if (pIsDangerous) {
            witherskull.m_37629_(true);
        }
        witherskull.m_20343_(d0, d1, d2);
        this.m_9236_().m_7967_((Entity)witherskull);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 750.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        })});
    }

    @Override
    public boolean wantsToAttack(LivingEntity target, LivingEntity living) {
        return this.m_9236_().m_46791_() != Difficulty.PEACEFUL;
    }

    @Override
    @Nullable
    protected BossCrystal.Type getDeathCrystalType() {
        return BossCrystal.Type.NETHER;
    }

    @Override
    public ResourceLocation lootTable() {
        return JLootTables.WITHERING_BEAST_CRYSTAL;
    }

    @Override
    public boolean showBarWhenSpawned() {
        return true;
    }
}

