/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.corba;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JFlyingEntity;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Overseer
extends JFlyingEntity {
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.overseer.idle");

    public Overseer(EntityType<? extends JFlyingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.CORBA, 5.0f);
    }

    @Override
    public void addGoals() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new ShootFireballGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, e -> Math.abs(e.m_20186_() - this.m_20186_()) <= 4.0));
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)JSounds.OVERSEER.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.OVERSEER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)JSounds.OVERSEER_DEATH.get();
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 62.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> state.setAndContinue(this.IDLE))});
    }

    @Override
    public boolean despawnInPeaceful() {
        return true;
    }

    protected float m_6121_() {
        return 2.5f;
    }

    public int m_5792_() {
        return 2;
    }

    public static boolean checkSpawn(EntityType<Overseer> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && random.m_188503_(10) == 0 && Overseer.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static class ShootFireballGoal
    extends Goal {
        private final Overseer seer;
        public int chargeTime;

        public ShootFireballGoal(Overseer pseer) {
            this.seer = pseer;
        }

        public boolean m_8036_() {
            return this.seer.m_5448_() != null;
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.seer.m_5448_();
            if (livingentity != null) {
                if (livingentity.m_20280_((Entity)this.seer) < 4096.0 && this.seer.m_142582_((Entity)livingentity)) {
                    Level level = this.seer.m_9236_();
                    --this.chargeTime;
                    if (this.chargeTime == 10 && !this.seer.m_20067_()) {
                        level.m_5898_(null, 1015, this.seer.m_20183_(), 0);
                    }
                    if (this.chargeTime == 20) {
                        Vec3 vec3 = this.seer.m_20252_(1.0f);
                        double d2 = livingentity.m_20185_() - (this.seer.m_20185_() + vec3.f_82479_ * 4.0);
                        double d3 = livingentity.m_20227_(0.5) - (0.5 + this.seer.m_20227_(0.5));
                        double d4 = livingentity.m_20189_() - (this.seer.m_20189_() + vec3.f_82481_ * 4.0);
                        if (!this.seer.m_20067_()) {
                            level.m_5898_(null, 1016, this.seer.m_20183_(), 0);
                        }
                        SmallFireball fireball = new SmallFireball(level, (LivingEntity)this.seer, d2, d3, d4);
                        fireball.m_6034_(this.seer.m_20185_() + vec3.f_82479_ * 4.0, this.seer.m_20227_(0.5) + 0.5, fireball.m_20189_() + vec3.f_82481_ * 4.0);
                        level.m_7967_((Entity)fireball);
                        this.chargeTime = -40;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
            }
        }
    }
}

