/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.corba;

import java.util.EnumSet;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JFlyingEntity;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class SwampFly
extends JFlyingEntity {
    public SwampFly(EntityType<? extends JFlyingEntity> type, Level worldIn) {
        super(type, worldIn);
        this.setKnowledge(EnumKnowledge.CORBA, 2.0f);
        this.f_21342_ = new FlyMoveHelperController(this);
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    public int m_5792_() {
        return 10;
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_150930_(Items.f_42590_)) {
            player.m_5496_((SoundEvent)JSounds.BOTTLE_PLUG.get(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)((Block)JBlocks.SWAMP_LAMP.get()).m_5456_().m_7968_());
            player.m_21008_(hand, itemstack1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new FlyRandomFlyGoal(this, 0.2));
        this.f_21345_.m_25352_(7, (Goal)new LookAroundGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void addGoals() {
    }

    @Override
    public boolean despawnInPeaceful() {
        return false;
    }

    static class FlyMoveHelperController
    extends MoveControl {
        private final JFlyingEntity entity;
        private int floatDuration;

        public FlyMoveHelperController(JFlyingEntity entity) {
            super((Mob)entity);
            this.entity = entity;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.entity.m_217043_().m_188503_(3) + 1;
                Vec3 vector3d = new Vec3(this.f_24975_ - this.entity.m_20185_(), this.f_24976_ - this.entity.m_20186_(), this.f_24977_ - this.entity.m_20189_());
                double d0 = vector3d.m_82553_();
                if (this.canReach(vector3d = vector3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.entity.m_20256_(this.entity.m_20184_().m_82549_(vector3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 vector3d_, int int_) {
            AABB a = this.entity.m_20191_();
            for (int i = 1; i < int_; ++i) {
                a = a.m_82383_(vector3d_);
                if (this.entity.m_9236_().m_45756_((Entity)this.entity, a)) continue;
                return false;
            }
            return true;
        }
    }

    static class FlyRandomFlyGoal
    extends Goal {
        private final JFlyingEntity entity;
        public final double speed;

        public FlyRandomFlyGoal(JFlyingEntity entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl m = this.entity.m_21566_();
            if (!m.m_24995_()) {
                return true;
            }
            double d0 = m.m_25000_() - this.entity.m_20185_();
            double d3 = d0 * d0 + (d1 = m.m_25001_() - this.entity.m_20186_()) * d1 + (d2 = m.m_25002_() - this.entity.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.entity.m_217043_();
            double d0 = this.entity.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.entity.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 8.0f);
            double d2 = this.entity.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.entity.m_21566_().m_6849_(d0, d1, d2, this.speed);
        }
    }

    static class LookAroundGoal
    extends Goal {
        private final JFlyingEntity entity;

        public LookAroundGoal(JFlyingEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            Vec3 vector3d = this.entity.m_20184_();
            this.entity.m_146922_(-((float)Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_)) * 57.295776f);
            this.entity.f_20883_ = this.entity.m_146908_();
        }
    }
}

