/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.euca.npc;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.jitl.client.ChatUtils;
import net.jitl.common.entity.base.CurrencyForItemsTrade;
import net.jitl.common.entity.base.JVillagerEntity;
import net.jitl.core.init.internal.JItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Crypian
extends JVillagerEntity {
    private static final EntityDataAccessor<Boolean> DATA_CAN_TRADE = SynchedEntityData.m_135353_(Crypian.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ALLOY_HOUSE = SynchedEntityData.m_135353_(Crypian.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new CurrencyForItemsTrade((ItemLike)JItems.PERIDOT_GEMSTONE.get(), 1, (ItemLike)Items.f_42522_, 1, 12, 5)}));
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.crypian.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.crypian.idle");

    public Crypian(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    protected void m_8097_() {
        super.m_8097_();
        int chance = this.f_19796_.m_188503_(2);
        this.f_19804_.m_135372_(DATA_CAN_TRADE, (Object)(chance == 0 ? 1 : 0));
        this.f_19804_.m_135372_(DATA_ALLOY_HOUSE, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("canTrade", ((Boolean)this.f_19804_.m_135370_(DATA_CAN_TRADE)).booleanValue());
        compound.m_128379_("alloyHouse", ((Boolean)this.f_19804_.m_135370_(DATA_ALLOY_HOUSE)).booleanValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCanTrade(compound.m_128471_("canTrade"));
        this.setAlloyHouse(compound.m_128471_("alloyHouse"));
    }

    public void setAlloyHouse(boolean canTrade) {
        this.f_19804_.m_135381_(DATA_ALLOY_HOUSE, (Object)canTrade);
    }

    public void setCanTrade(boolean canTrade) {
        this.f_19804_.m_135381_(DATA_CAN_TRADE, (Object)canTrade);
    }

    public boolean isAlloyHouse() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ALLOY_HOUSE);
    }

    @Override
    public boolean canTrade() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CAN_TRADE);
    }

    @Override
    protected Int2ObjectMap<VillagerTrades.ItemListing[]> getVillagerTrades() {
        return TRADES;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand playerHand) {
        if (this.m_6084_() && this.m_7962_() == null && this.canTrade() && !this.isAlloyHouse()) {
            switch (this.f_19796_.m_188503_(3)) {
                case 0: {
                    ChatUtils.addDialogStyleChat(player, "jitl.trader.crypian1");
                    break;
                }
                case 1: {
                    ChatUtils.addDialogStyleChat(player, "jitl.trader.crypian2");
                    break;
                }
                case 2: {
                    ChatUtils.addDialogStyleChat(player, "jitl.trader.crypian3");
                }
            }
            this.trade(player);
        } else if (this.isAlloyHouse()) {
            switch (this.f_19796_.m_188503_(3)) {
                case 0: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian_alloy1");
                    break;
                }
                case 1: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian_alloy2");
                    break;
                }
                case 2: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian_alloy3");
                }
            }
        } else {
            switch (this.f_19796_.m_188503_(2)) {
                case 0: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian1");
                    break;
                }
                case 1: {
                    ChatUtils.addDialogStyleChat(player, "jitl.npc.crypian2");
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        })});
    }
}

