/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.euca.npc;

import net.jitl.client.ChatUtils;
import net.jitl.common.block.entity.PedestalTile;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RoyalKing
extends PathfinderMob
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> DATA_IS_ACTIVATED = SynchedEntityData.m_135353_(RoyalKing.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HAS_CROWN = SynchedEntityData.m_135353_(RoyalKing.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.royal_king.idle");

    public RoyalKing(EntityType<? extends RoyalKing> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> state.setAndContinue(this.IDLE))});
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isActivated() && !this.m_9236_().f_46443_) {
            if (this.hasCrown()) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_ + 0.5, this.m_20182_().f_82480_ + (double)1.4f, this.m_20182_().f_82481_ + 0.5, new ItemStack((ItemLike)JItems.EUDOR_CROWN.get(), 1)));
            }
            this.setHasCrown(false);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_ACTIVATED, (Object)false);
        this.f_19804_.m_135372_(DATA_HAS_CROWN, (Object)true);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("activated", ((Boolean)this.f_19804_.m_135370_(DATA_IS_ACTIVATED)).booleanValue());
        compound.m_128379_("hasCrown", ((Boolean)this.f_19804_.m_135370_(DATA_HAS_CROWN)).booleanValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setActivated(compound.m_128471_("activated"));
        this.setHasCrown(compound.m_128471_("hasCrown"));
    }

    public void setActivated(boolean activated) {
        this.f_19804_.m_135381_(DATA_IS_ACTIVATED, (Object)activated);
    }

    public void setHasCrown(boolean activated) {
        this.f_19804_.m_135381_(DATA_HAS_CROWN, (Object)activated);
    }

    public boolean isActivated() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_ACTIVATED);
    }

    public boolean hasCrown() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_CROWN);
    }

    protected InteractionResult m_6071_(Player playerEntity, InteractionHand hand) {
        int check_radius = 10;
        int totalRoyalDisks = 0;
        int totalMetalDisks = 0;
        int totalTablets = 0;
        int neededRoyalDisks = 4;
        int neededMetalDisks = 2;
        int neededTables = 8;
        Level world = this.m_9236_();
        BlockPos entityPos = BlockPos.m_274446_((Position)this.m_20182_());
        for (int x = -check_radius; x <= check_radius; ++x) {
            for (int z = -check_radius; z <= check_radius; ++z) {
                for (int y = -check_radius; y <= check_radius; ++y) {
                    PedestalTile tile;
                    BlockPos pos = entityPos.m_7918_(x, y, z);
                    Block block = world.m_8055_(pos).m_60734_();
                    if (block != JBlocks.ROYAL_PEDESTAL.get() || (tile = (PedestalTile)world.m_7702_(pos)) == null) continue;
                    if (tile.m_8020_(0).m_41720_().equals(JItems.ROYAL_DISK.get())) {
                        ++totalRoyalDisks;
                        --neededRoyalDisks;
                    }
                    if (tile.m_8020_(0).m_41720_().equals(JItems.METAL_DISK.get())) {
                        ++totalMetalDisks;
                        --neededMetalDisks;
                    }
                    if (tile.m_8020_(0).m_41720_().equals(JItems.EUCA_TABLET.get())) {
                        ++totalTablets;
                        --neededTables;
                    }
                    if (!this.isActivated()) continue;
                    tile.m_6836_(0, ItemStack.f_41583_);
                }
            }
        }
        if (totalRoyalDisks >= 4 && totalTablets >= 8 && totalMetalDisks >= 2) {
            this.m_5496_((SoundEvent)JSounds.COIN_PICKUP.get(), 1.5f, 1.0f);
            this.setActivated(true);
        }
        if (this.hasCrown()) {
            ChatUtils.addDialogStyleChat(playerEntity, "I need " + neededRoyalDisks + " more Royal Disks, " + neededMetalDisks + " Metal Disks and " + neededTables + " Euca Tablets");
        }
        if (!this.hasCrown()) {
            ChatUtils.addDialogStyleChat(playerEntity, "jitl.king.hero");
        }
        return super.m_6071_(playerEntity, hand);
    }
}

