/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.frozen;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JNeutralMonster;
import net.jitl.core.helper.MathHelper;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class FrozenTrollEntity
extends JNeutralMonster {
    private static final EntityDataAccessor<Boolean> IS_ANGRY_ID = SynchedEntityData.m_135353_(FrozenTrollEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public FrozenTrollEntity(EntityType<? extends FrozenTrollEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21553_(true);
        this.setKnowledge(EnumKnowledge.FROZEN, 5.0f);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 42.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("angry", ((Boolean)this.f_19804_.m_135370_(IS_ANGRY_ID)).booleanValue());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAngry(compound.m_128471_("angry"));
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ANGRY_ID, (Object)false);
    }

    public boolean m_21660_() {
        return (Boolean)this.f_19804_.m_135370_(IS_ANGRY_ID);
    }

    public void setAngry(boolean angry) {
        this.f_19804_.m_135381_(IS_ANGRY_ID, (Object)angry);
    }

    public void m_216990_(SoundEvent soundEvent_) {
        this.m_5496_(soundEvent_, this.m_6121_(), this.m_6100_());
    }

    public boolean m_7327_(@NotNull Entity entityIn) {
        if (super.m_7327_(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                entityIn.m_20256_(entityIn.m_20184_().m_82520_((double)(-MathHelper.sin((float)(this.f_20907_ * Math.PI / 180.0)) * 2.0f), 0.1, (double)(MathHelper.cos((float)(this.f_20907_ * Math.PI / 180.0)) * 2.0f)));
            }
            return true;
        }
        return false;
    }

    public void m_8032_() {
        if (this.m_21660_()) {
            this.m_5496_(this.getAngryAmbientSound(), this.m_6121_(), this.m_6100_());
        } else {
            this.m_5496_(this.getCuteAmbientSound(), this.m_6121_(), this.m_6100_() + 1.0f);
        }
    }

    protected SoundEvent getCuteAmbientSound() {
        return (SoundEvent)JSounds.FROZEN_TROLL_INTRIGUED.get();
    }

    protected SoundEvent getAngryAmbientSound() {
        return (SoundEvent)JSounds.FROZEN_TROLL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return (SoundEvent)JSounds.FROZEN_TROLL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)JSounds.FROZEN_TROLL_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }
}

