/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.frozen;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.jitl.common.entity.base.JTamableEntity;
import net.jitl.common.entity.goal.ShiverwolfBegGoal;
import net.jitl.core.init.JITL;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class Shiverwolf
extends JTamableEntity {
    private static final EntityDataAccessor<Boolean> DATA_INTERESTED_ID = SynchedEntityData.m_135353_(Shiverwolf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(Shiverwolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Shiverwolf.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_348295_ -> {
        EntityType entitytype = p_348295_.m_6095_();
        return entitytype == EntityType.f_20520_ || entitytype == EntityType.f_20517_ || entitytype == EntityType.f_20452_;
    };
    private float interestedAngle;
    private float interestedAngleO;
    private boolean isWet;
    private boolean isShaking;
    private float shakeAnim;
    private float shakeAnimO;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;

    public Shiverwolf(EntityType<? extends JTamableEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_7105_(false);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, new WolfAvoidEntityGoal<Llama>(this, Llama.class, 24.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new ShiverwolfBegGoal(this, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Shiverwolf)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, PREY_SELECTOR));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.f_30122_));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, false));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 8.0).m_22265_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_INTERESTED_ID, (Object)false);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState block) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        this.m_21678_(compound);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)compound.m_128451_("CollarColor")));
        }
        this.m_147285_(this.m_9236_(), compound);
    }

    public ResourceLocation getTexture() {
        if (this.m_21824_()) {
            return JITL.rl("textures/entity/frozen/shiverwolf_tame.png");
        }
        return this.m_21660_() ? JITL.rl("textures/entity/frozen/shiverwolf_angry.png") : JITL.rl("textures/entity/frozen/shiverwolf.png");
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return SoundEvents.f_12619_;
        }
        if (this.f_19796_.m_188503_(3) != 0) {
            return SoundEvents.f_12617_;
        }
        return this.m_21824_() && this.m_21223_() < 20.0f ? SoundEvents.f_12625_ : SoundEvents.f_12622_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12621_;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.isWet && !this.isShaking && !this.m_21691_() && this.m_20096_()) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
            this.m_9236_().m_7605_((Entity)this, (byte)8);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.interestedAngleO = this.interestedAngle;
            this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
            if (this.m_20071_()) {
                this.isWet = true;
                if (this.isShaking && !this.m_9236_().f_46443_) {
                    this.m_9236_().m_7605_((Entity)this, (byte)56);
                    this.cancelShake();
                }
            } else if ((this.isWet || this.isShaking) && this.isShaking) {
                if (this.shakeAnim == 0.0f) {
                    this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                    this.m_146850_(GameEvent.f_223710_);
                }
                this.shakeAnimO = this.shakeAnim;
                this.shakeAnim += 0.05f;
                if (this.shakeAnimO >= 2.0f) {
                    this.isWet = false;
                    this.isShaking = false;
                    this.shakeAnimO = 0.0f;
                    this.shakeAnim = 0.0f;
                }
                if (this.shakeAnim > 0.4f) {
                    float f = (float)this.m_20186_();
                    int i = (int)(Mth.m_14031_((float)((this.shakeAnim - 0.4f) * (float)Math.PI)) * 7.0f);
                    Vec3 vec3 = this.m_20184_();
                    for (int j = 0; j < i; ++j) {
                        float f1 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        float f2 = (this.f_19796_.m_188501_() * 2.0f - 1.0f) * this.m_20205_() * 0.5f;
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)f1, (double)(f + 0.8f), this.m_20189_() + (double)f2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
            }
        }
    }

    private void cancelShake() {
        this.isShaking = false;
        this.shakeAnim = 0.0f;
        this.shakeAnimO = 0.0f;
    }

    @Override
    public void m_6667_(@NotNull DamageSource cause) {
        this.isWet = false;
        this.isShaking = false;
        this.shakeAnimO = 0.0f;
        this.shakeAnim = 0.0f;
        super.m_6667_(cause);
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
    }

    public boolean isWet() {
        return this.isWet;
    }

    public float getWetShade(float partialTicks) {
        return Math.min(0.75f + Mth.m_14179_((float)partialTicks, (float)this.shakeAnimO, (float)this.shakeAnim) / 2.0f * 0.25f, 1.0f);
    }

    public float getBodyRollAngle(float partialTicks, float offset) {
        float f = (Mth.m_14179_((float)partialTicks, (float)this.shakeAnimO, (float)this.shakeAnim) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return Mth.m_14031_((float)(f * (float)Math.PI)) * Mth.m_14031_((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public float getHeadRollAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.interestedAngleO, (float)this.interestedAngle) * 0.15f * (float)Math.PI;
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12618_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public int setBaseHealth() {
        return 30;
    }

    @Override
    public int setTameHealth() {
        return 40;
    }

    @Override
    public Item getTameItem() {
        return (Item)JItems.FROZEN_ICE_BALL.get();
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)pPlayer) || this.m_21824_() || itemstack.m_150930_(this.getTameItem()) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            InteractionResult interactionresult;
            if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(Objects.requireNonNull(itemstack.getFoodProperties((LivingEntity)this)).m_38744_());
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeItem dyeitem = (DyeItem)item;
                if (this.m_21830_((LivingEntity)pPlayer)) {
                    DyeColor dyecolor = dyeitem.m_41089_();
                    if (dyecolor != this.getCollarColor()) {
                        this.setCollarColor(dyecolor);
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(pPlayer, pHand);
                }
            }
            if ((!(interactionresult = super.m_6071_(pPlayer, pHand)).m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)pPlayer)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (itemstack.m_150930_(this.getTameItem()) && !this.m_21660_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_7822_(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.shakeAnim = 0.0f;
            this.shakeAnimO = 0.0f;
        } else if (id == 56) {
            this.cancelShake();
        } else {
            super.m_7822_(id);
        }
    }

    public float getTailAngle() {
        if (this.m_21660_()) {
            return 1.5393804f;
        }
        if (this.m_21824_()) {
            float f = this.m_21233_();
            float f1 = (f - this.m_21223_()) / f;
            return (0.55f - f1 * 0.4f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    @Override
    public void m_7870_(int time) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)time);
    }

    @Override
    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @Override
    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    @Override
    public void m_6925_(@Nullable UUID target) {
        this.persistentAngerTarget = target;
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor collarColor) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)collarColor.m_41060_());
    }

    @Nullable
    public Shiverwolf getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        Shiverwolf wolf = (Shiverwolf)((EntityType)JEntities.SHIVERWOLF_TYPE.get()).m_20615_((Level)level);
        if (wolf != null && otherParent instanceof Shiverwolf) {
            Shiverwolf wolf1 = (Shiverwolf)otherParent;
            if (this.m_21824_()) {
                wolf.m_21816_(this.m_21805_());
                wolf.m_7105_(true);
                if (this.f_19796_.m_188499_()) {
                    wolf.setCollarColor(this.getCollarColor());
                } else {
                    wolf.setCollarColor(wolf1.getCollarColor());
                }
            }
        }
        return wolf;
    }

    public void setIsInterested(boolean isInterested) {
        this.f_19804_.m_135381_(DATA_INTERESTED_ID, (Object)isInterested);
    }

    public boolean m_7848_(@NotNull Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (otherAnimal instanceof Shiverwolf) {
            Shiverwolf wolf = (Shiverwolf)otherAnimal;
            if (!wolf.m_21824_()) {
                return false;
            }
            return !wolf.m_21825_() && this.m_27593_() && wolf.m_27593_();
        }
        return false;
    }

    public boolean isInterested() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INTERESTED_ID);
    }

    @Override
    public boolean m_7757_(@NotNull LivingEntity target, @NotNull LivingEntity owner) {
        if (!(target instanceof Creeper || target instanceof Ghast || target instanceof ArmorStand)) {
            if (!(target instanceof Shiverwolf)) {
                AbstractHorse abstracthorse;
                if (target instanceof Player) {
                    Player player1;
                    Player player = (Player)target;
                    if (owner instanceof Player && !(player1 = (Player)owner).m_7099_(player)) {
                        return false;
                    }
                }
                if (target instanceof AbstractHorse && (abstracthorse = (AbstractHorse)target).m_30614_()) {
                    return false;
                }
                if (target instanceof TamableAnimal) {
                    TamableAnimal tamableanimal = (TamableAnimal)target;
                    return !tamableanimal.m_21824_();
                }
                return true;
            }
            Shiverwolf wolf = (Shiverwolf)target;
            return !wolf.m_21824_() || wolf.m_269323_() != owner;
        }
        return false;
    }

    @Override
    public boolean m_6573_(@NotNull Player pPlayer) {
        return !this.m_21660_();
    }

    @Override
    @NotNull
    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.6f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    class WolfAvoidEntityGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final Shiverwolf wolf;

        public WolfAvoidEntityGoal(Shiverwolf wolf, Class<T> entityClassToAvoid, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
            super((PathfinderMob)wolf, entityClassToAvoid, maxDist, walkSpeedModifier, sprintSpeedModifier);
            this.wolf = wolf;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.f_25016_ instanceof Llama && !this.wolf.m_21824_() && this.avoidLlama((Llama)this.f_25016_);
        }

        private boolean avoidLlama(Llama llama) {
            return llama.m_30823_() >= Shiverwolf.this.f_19796_.m_188503_(5);
        }

        public void m_8056_() {
            Shiverwolf.this.m_6710_(null);
            super.m_8056_();
        }

        public void m_8037_() {
            Shiverwolf.this.m_6710_(null);
            super.m_8037_();
        }
    }
}

