/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.frozen.npc;

import net.jitl.client.ChatUtils;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.block.entity.PedestalTile;
import net.jitl.common.capability.stats.PlayerStatsProvider;
import net.jitl.common.entity.projectile.EssenciaBoltEntity;
import net.jitl.core.init.internal.JBlocks;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FrozenGuardian
extends PathfinderMob
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> DATA_IS_ACTIVATED = SynchedEntityData.m_135353_(FrozenGuardian.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int death_timer = 50;
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.frozen_guardian.idle");

    public FrozenGuardian(EntityType<? extends FrozenGuardian> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> state.setAndContinue(this.IDLE))});
    }

    public static AttributeSupplier createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22265_();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isActivated()) {
            --this.death_timer;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() - 0.5 + this.f_19796_.m_188500_(), this.m_20186_() + 0.5 + this.f_19796_.m_188500_(), this.m_20189_() - 0.5 + this.f_19796_.m_188500_(), this.f_19796_.m_188583_() * 0.05, 0.15, this.f_19796_.m_188583_() * 0.05);
            if (this.death_timer <= 0) {
                for (int i = 0; i < 24; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, this.m_20185_() - Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.45, (double)0.75), this.m_20186_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)0.5, (double)2.0), this.m_20189_() - Mth.m_216263_((RandomSource)this.f_19796_, (double)-0.45, (double)0.75), this.f_19796_.m_188583_() * 0.05, 0.15, this.f_19796_.m_188583_() * 0.05);
                }
                this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_ + 0.5, this.m_20182_().f_82480_ + (double)1.4f, this.m_20182_().f_82481_ + 0.5, new ItemStack((ItemLike)JItems.STAFF_OF_CONJURING.get(), 1)));
                }
                this.death_timer = 100;
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_ACTIVATED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("activated", ((Boolean)this.f_19804_.m_135370_(DATA_IS_ACTIVATED)).booleanValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setActivated(compound.m_128471_("activated"));
    }

    public void setActivated(boolean activated) {
        this.f_19804_.m_135381_(DATA_IS_ACTIVATED, (Object)activated);
    }

    public boolean isActivated() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_ACTIVATED);
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public void m_7334_(Entity entity) {
    }

    protected void m_7324_(Entity entityIn) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    protected InteractionResult m_6071_(Player playerEntity, InteractionHand hand) {
        int check_radius = 8;
        int totalPedestals = 0;
        Level world = this.m_9236_();
        BlockPos entityPos = BlockPos.m_274446_((Position)this.m_20182_());
        for (int x = -check_radius; x <= check_radius; ++x) {
            for (int z = -check_radius; z <= check_radius; ++z) {
                for (int y = -check_radius; y <= check_radius; ++y) {
                    PedestalTile tile;
                    BlockPos pos = entityPos.m_7918_(x, y, z);
                    Block block = world.m_8055_(pos).m_60734_();
                    if (block != JBlocks.FROZEN_PEDESTAL.get() || (tile = (PedestalTile)world.m_7702_(pos)) == null || !tile.m_8020_(0).m_41720_().equals(JItems.FROSTBORN_SOUL.get())) continue;
                    if (this.isActivated()) {
                        if (!this.m_9236_().f_46443_) {
                            this.summonLightning(pos);
                            this.disableFrozenBlizzard();
                        }
                        tile.m_6836_(0, ItemStack.f_41583_);
                    }
                    ++totalPedestals;
                }
            }
        }
        if (totalPedestals >= 8) {
            this.m_5496_((SoundEvent)JSounds.FROZEN_GUARDIAN_DEATH.get(), 1.5f, 1.0f);
            ChatUtils.addDialogStyleChat(playerEntity, "jitl.npc.frozen_guardian1");
            this.setActivated(true);
        } else {
            ChatUtils.addDialogStyleChat(playerEntity, "jitl.npc.frozen_guardian2");
        }
        return super.m_6071_(playerEntity, hand);
    }

    public void summonLightning(BlockPos pos) {
        EssenciaBoltEntity bolt = new EssenciaBoltEntity((EntityType<? extends LightningBolt>)((EntityType)JEntities.ESSENCIA_BOLT_TYPE.get()), this.m_9236_());
        bolt.m_6034_(pos.m_123341_(), (double)pos.m_123342_() + 1.0, pos.m_123343_());
        bolt.setARGB(5950463);
        bolt.m_20874_(true);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7967_((Entity)bolt);
        }
    }

    public void disableFrozenBlizzard() {
        int playerArea = 10;
        AABB axisalignedbb = AABB.m_82333_((Vec3)this.m_20182_()).m_82400_((double)playerArea);
        for (Player player : this.m_9236_().m_45976_(Player.class, axisalignedbb)) {
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> stats.setBlizzard(true));
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(knowledge -> knowledge.addXP(EnumKnowledge.FROZEN, 15.0f, player));
        }
    }
}

