/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.goal;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.jitl.common.entity.overworld.Floro;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class FloroAttackGoal
extends Goal {
    private final Mob mob;
    private final Floro rangedAttackMob;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private final int attackIntervalMin;
    private final int attackIntervalMax;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public FloroAttackGoal(Floro pRangedAttackMob, double pSpeedModifier, int pAttackInterval, float pAttackRadius) {
        this(pRangedAttackMob, pSpeedModifier, pAttackInterval, pAttackInterval, pAttackRadius);
    }

    public FloroAttackGoal(Floro pRangedAttackMob, double pSpeedModifier, int pAttackIntervalMin, int pAttackIntervalMax, float pAttackRadius) {
        if (pRangedAttackMob == null) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackMob = pRangedAttackMob;
        this.mob = pRangedAttackMob;
        this.speedModifier = pSpeedModifier;
        this.attackIntervalMin = pAttackIntervalMin;
        this.attackIntervalMax = pAttackIntervalMax;
        this.attackRadius = pAttackRadius;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null && livingentity.m_6084_() && !this.rangedAttackMob.isHidden()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() || this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
        this.rangedAttackMob.setHidden(true);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
        this.seeTime = flag ? ++this.seeTime : 0;
        if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.mob.m_21573_().m_26573_();
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }
        this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!flag) {
                return;
            }
            float f = (float)Math.sqrt(d0) / this.attackRadius;
            float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.m_6504_(this.target, f1);
            this.rangedAttackMob.setShooting(true);
            this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.attackTime < 0) {
            this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            this.rangedAttackMob.setShooting(false);
        }
    }
}

