/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.overworld;

import java.util.EnumSet;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JMonsterEntity;
import net.jitl.common.entity.goal.FloroAttackGoal;
import net.jitl.common.entity.projectile.FloroMudEntity;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Floro
extends JMonsterEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> HIDDEN = SynchedEntityData.m_135353_(Floro.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SHOOTING = SynchedEntityData.m_135353_(Floro.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SHOWING = SynchedEntityData.m_135353_(Floro.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean isHiding = false;
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.floro.walk");
    private final RawAnimation HIDDEN_ANIM = RawAnimation.begin().thenLoop("animation.floro.hidden");
    private final RawAnimation SHOWING = RawAnimation.begin().thenLoop("animation.floro.showing");
    private final RawAnimation ATTACK = RawAnimation.begin().thenLoop("animation.floro.shoot");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.floro.idle");

    public Floro(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.setKnowledge(EnumKnowledge.OVERWORLD, 5.0f);
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            if (this.isHidden()) {
                return state.setAndContinue(this.HIDDEN_ANIM);
            }
            if (this.isShooting()) {
                return state.setAndContinue(this.ATTACK);
            }
            if (this.isShowing()) {
                return state.setAndContinue(this.SHOWING);
            }
            return state.setAndContinue(this.IDLE);
        })});
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        this.setHidden(false);
        return super.m_6469_(pSource, pAmount);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HIDDEN, (Object)true);
        this.f_19804_.m_135372_(IS_SHOOTING, (Object)false);
        this.f_19804_.m_135372_(IS_SHOWING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("hidden", this.isHidden());
        compound.m_128379_("shooting", this.isShooting());
        compound.m_128379_("showing", this.isShowing());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("hidden")) {
            this.setHidden(compound.m_128471_("hidden"));
        }
        if (compound.m_128441_("shooting")) {
            this.setShooting(compound.m_128471_("shooting"));
        }
    }

    public void onAddedToWorld() {
        if (this.m_21515_() && this.isHidden()) {
            this.setHidden(true);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloroRevealingGoal());
        this.f_21345_.m_25352_(2, (Goal)new FloroHidingGoal());
        this.f_21345_.m_25352_(3, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new FloroAttackGoal(this, 1.0, 20, 15.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, false, null));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Bee.class, 5, true, false, null));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    public void m_8107_() {
        if (this.m_21515_()) {
            if (this.isHidden()) {
                this.isHiding = false;
            }
            if (this.canMove()) {
                this.f_21345_.m_25374_(Goal.Flag.LOOK);
                this.f_21345_.m_25374_(Goal.Flag.JUMP);
            } else {
                this.f_21345_.m_25355_(Goal.Flag.LOOK);
                this.f_21345_.m_25355_(Goal.Flag.JUMP);
            }
        }
        super.m_8107_();
    }

    public void m_5997_(double x, double y, double z) {
        if (this.canMove()) {
            super.m_5997_(x, y, z);
        } else {
            super.m_5997_(0.0, 0.0, 0.0);
        }
    }

    public void m_147240_(double strength, double ratioX, double ratioZ) {
        if (this.canMove()) {
            super.m_147240_(strength, ratioX, ratioZ);
        }
    }

    private boolean canMove() {
        return !this.isHidden() && !this.isHiding;
    }

    public boolean isHidden() {
        return (Boolean)this.m_20088_().m_135370_(HIDDEN);
    }

    public boolean isShooting() {
        return (Boolean)this.m_20088_().m_135370_(IS_SHOOTING);
    }

    public boolean isShowing() {
        return (Boolean)this.m_20088_().m_135370_(IS_SHOWING);
    }

    public void setHidden(boolean value) {
        this.m_20088_().m_135381_(HIDDEN, (Object)value);
    }

    public void setShooting(boolean value) {
        this.m_20088_().m_135381_(IS_SHOOTING, (Object)value);
    }

    public void setShowing(boolean value) {
        this.m_20088_().m_135381_(IS_SHOWING, (Object)value);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)JSounds.HONGO_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)JSounds.HONGO_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)JSounds.HONGO_DEATH.get();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.78f;
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        FloroMudEntity mud = new FloroMudEntity(this.m_9236_(), (LivingEntity)this, 3.5f);
        double d0 = pTarget.m_20188_() - (double)1.1f;
        double d1 = pTarget.m_20185_() - this.m_20185_();
        double d2 = d0 - mud.m_20186_();
        double d3 = pTarget.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        mud.m_6686_(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.m_5496_(SoundEvents.f_12479_, 1.0f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)mud);
    }

    private class FloroRevealingGoal
    extends Goal {
        public FloroRevealingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !Floro.this.canMove() && Floro.this.m_5448_() != null;
        }

        public void m_8056_() {
            if (Floro.this.isHidden()) {
                Floro.this.setShowing(true);
            } else {
                Floro.this.setHidden(false);
            }
        }

        public boolean m_6767_() {
            return false;
        }
    }

    private class FloroHidingGoal
    extends Goal {
        public FloroHidingGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !Floro.this.isHidden() && Floro.this.m_5448_() == null;
        }

        public boolean m_8045_() {
            return !Floro.this.isHidden();
        }

        public void m_8056_() {
            Floro.this.isHiding = true;
        }

        public void m_8037_() {
            if (!Floro.this.isHidden() && Floro.this.f_19797_ % 240 == 0) {
                Floro.this.setHidden(true);
            }
        }

        public void m_8041_() {
            Floro.this.isHiding = false;
        }
    }
}

