/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.overworld.npc;

import java.util.Objects;
import net.jitl.client.ChatUtils;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.block.entity.container.SentacoinMerchantMenu;
import net.jitl.common.capability.stats.PlayerStatsProvider;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OverworldSentryStalker
extends PathfinderMob
implements GeoEntity,
Npc {
    private static final EntityDataAccessor<Boolean> DATA_IS_ACTIVATED = SynchedEntityData.m_135353_(OverworldSentryStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_HAS_KEY = SynchedEntityData.m_135353_(OverworldSentryStalker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.neutral_sentry_stalker.idle");
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.neutral_sentry_stalker.walk");

    public OverworldSentryStalker(EntityType<? extends OverworldSentryStalker> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        })});
    }

    public boolean isClientSide() {
        return this.m_9236_().m_5776_();
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isActivated() && !this.m_9236_().f_46443_ && this.hasKey()) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_ + 0.5, this.m_20182_().f_82480_ + (double)1.4f, this.m_20182_().f_82481_ + 0.5, new ItemStack((ItemLike)JItems.SENTRY_KEY.get(), 1)));
            this.m_5496_((SoundEvent)JSounds.COIN_PICKUP.get(), 1.5f, 1.0f);
            this.setHasKey(false);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_ACTIVATED, (Object)false);
        this.f_19804_.m_135372_(DATA_HAS_KEY, (Object)true);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("activated", ((Boolean)this.f_19804_.m_135370_(DATA_IS_ACTIVATED)).booleanValue());
        compound.m_128379_("hasKey", ((Boolean)this.f_19804_.m_135370_(DATA_HAS_KEY)).booleanValue());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setActivated(compound.m_128471_("activated"));
        this.setHasKey(compound.m_128471_("hasKey"));
    }

    public void setActivated(boolean activated) {
        this.f_19804_.m_135381_(DATA_IS_ACTIVATED, (Object)activated);
    }

    public void setHasKey(boolean activated) {
        this.f_19804_.m_135381_(DATA_HAS_KEY, (Object)activated);
    }

    public boolean isActivated() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_ACTIVATED);
    }

    public boolean hasKey() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_KEY);
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return false;
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
            if (stats.getLevel(EnumKnowledge.OVERWORLD) >= 75) {
                this.setActivated(true);
            }
            if (this.hasKey()) {
                ChatUtils.addDialogStyleChat(player, "jitl.sen.knowledge_1");
            }
            if (!this.hasKey()) {
                ChatUtils.addDialogStyleChat(player, "jitl.sen.unlocked");
                if (!this.m_9236_().f_46443_) {
                    player.m_5893_((MenuProvider)new SimpleMenuProvider((menu, inven, title) -> new SentacoinMerchantMenu(menu), Objects.requireNonNull(this.m_5446_())));
                }
            }
        });
        return super.m_6071_(player, hand);
    }
}

