/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.overworld.npc;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.jitl.client.ChatUtils;
import net.jitl.common.entity.base.CurrencyForItemsTrade;
import net.jitl.common.entity.base.JVillagerEntity;
import net.jitl.core.init.internal.JItems;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class RockiteGolem
extends JVillagerEntity {
    private static final Int2ObjectMap<VillagerTrades.ItemListing[]> TRADES = new Int2ObjectOpenHashMap((Map)ImmutableMap.of((Object)1, (Object)new VillagerTrades.ItemListing[]{new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_CRYSTAL_INGOT.get(), 4, (ItemLike)Items.f_42593_, 8, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_STONE_INGOT.get(), 4, (ItemLike)JItems.BACK_BITER.get(), 1, (ItemLike)JItems.CRYSTALLIZED_BATTLE_AXE.get(), 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_CRYSTAL_INGOT.get(), 4, (ItemLike)JItems.EARTHEN_HAMMER.get(), 1, (ItemLike)JItems.CRYSTALLIZED_HAMMER.get(), 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_STONE_INGOT.get(), 4, (ItemLike)JItems.EARTHEN_HAMMER.get(), 1, (ItemLike)JItems.ROCKY_HAMMER.get(), 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_STONE_INGOT.get(), 4, (ItemLike)JItems.STONE_CLUMP.get(), 4, (ItemLike)JItems.ROCK_LAUNCHER.get(), 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_CRYSTAL_INGOT.get(), 4, (ItemLike)JItems.STAFF_OF_ENLIGHTENMENT.get(), 1, (ItemLike)JItems.STAFF_OF_DIVINITY.get(), 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_CRYSTAL_INGOT.get(), 4, (ItemLike)JItems.STAFF_OF_DIVINITY.get(), 1, (ItemLike)JItems.CRYSTAL_STAFF.get(), 1, 99, 5), new CurrencyForItemsTrade((ItemLike)JItems.REINFORCED_STONE_INGOT.get(), 4, (ItemLike)JItems.BRONZED_BATTLE_AXE.get(), 1, (ItemLike)JItems.ROCKY_BATTLE_AXE.get(), 1, 99, 5)}));
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.rockite_golem.walk");
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.rockite_golem.idle");

    public RockiteGolem(EntityType<? extends JVillagerEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    public static boolean checkSpawn(EntityType<RockiteGolem> entity, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return (double)pos.m_123342_() < 40.0 && RockiteGolem.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand playerHand) {
        ChatUtils.addDialogStyleChat(player, "jitl.trader.rockite_golem");
        return super.m_6071_(player, playerHand);
    }

    @Override
    protected Int2ObjectMap<VillagerTrades.ItemListing[]> getVillagerTrades() {
        return TRADES;
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        })});
    }
}

