/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractKnifeEntity
extends AbstractArrow {
    private boolean dealtDamage;

    public AbstractKnifeEntity(EntityType<? extends AbstractArrow> type, Level world) {
        super(type, world);
    }

    public AbstractKnifeEntity(EntityType<? extends AbstractArrow> entityType, Level worldIn, LivingEntity player) {
        super(entityType, player, worldIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick() {
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        if ((this.dealtDamage || this.m_36797_()) && entity != null && !this.isAcceptableReturnOwner()) {
            if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                this.m_5552_(this.m_7941_(), 0.1f);
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_9236_().f_46443_) {
            this.onClientTick();
        }
        super.m_8119_();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return new ItemStack(this::pickupItem);
    }

    @NotNull
    public abstract Item pickupItem();

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("damage dealt", this.dealtDamage);
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.dealtDamage = compound.m_128471_("damage dealt");
    }
}

