/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DamagingProjectileEntity
extends ThrowableProjectile {
    private float damage;

    public DamagingProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, Level world) {
        super(type, world);
    }

    public DamagingProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, Level world, LivingEntity thrower, float damage) {
        super(type, thrower, world);
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.shouldDespawn()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.onClientTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick() {
    }

    protected boolean shouldDespawn() {
        return this.f_19797_ >= 200;
    }

    protected void m_6532_(HitResult result) {
        if (!this.m_9236_().f_46443_) {
            if (result.m_6662_() == HitResult.Type.ENTITY) {
                Entity target = ((EntityHitResult)result).m_82443_();
                if (!Objects.equals(target, this.m_19749_())) {
                    this.onEntityImpact(result, target);
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else if (result.m_6662_() == HitResult.Type.BLOCK) {
                this.onBlockImpact((BlockHitResult)result);
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void onEntityImpact(HitResult result, Entity target) {
        target.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.getDamage());
    }

    protected void onBlockImpact(BlockHitResult result) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected float m_7139_() {
        return 0.03f;
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("damage", this.damage);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.damage = compound.m_128457_("damage");
    }
}

