/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import java.util.EnumSet;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class EssenceArrowEntity
extends AbstractArrow
implements ItemSupplier {
    private EnumSet<BowEffects> effects;

    public EssenceArrowEntity(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
    }

    public EssenceArrowEntity(Level level, LivingEntity player, EnumSet<BowEffects> effects, float damage) {
        super((EntityType)JEntities.ESSENCE_ARROW_TYPE.get(), player, level);
        this.effects = effects;
        this.m_36781_(damage);
    }

    protected void m_5790_(@NotNull EntityHitResult r) {
        super.m_5790_(r);
        Entity entity = r.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (this.effects != null) {
                if (this.effects.contains((Object)BowEffects.WITHER)) {
                    this.applyPotionEffect(entity2, MobEffects.f_19615_, 100, 2);
                }
                if (this.effects.contains((Object)BowEffects.SLOWNESS)) {
                    this.applyPotionEffect(entity2, MobEffects.f_19597_, 100, 2);
                }
                if (this.effects.contains((Object)BowEffects.FLAME)) {
                    entity2.m_20254_(3);
                }
                if (this.effects.contains((Object)BowEffects.POISON)) {
                    this.applyPotionEffect(entity2, MobEffects.f_19614_, 100, 2);
                }
            }
        }
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.m_7846_();
    }

    private void applyPotionEffect(LivingEntity effectedEntity, MobEffect potionEffect, int duration, int amplifier) {
        effectedEntity.m_7292_(new MobEffectInstance(potionEffect, duration, amplifier));
    }

    protected boolean m_142470_(Player pPlayer) {
        return this.effects != null && !this.effects.contains((Object)BowEffects.CONSUMES_ESSENCE);
    }

    @NotNull
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)JItems.ESSENCE_ARROW.get());
    }

    public static enum BowEffects {
        WITHER,
        SLOWNESS,
        FLAME,
        POISON,
        DOUBLE_ARROW,
        CONSUMES_ESSENCE;

    }
}

