/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.jitl.common.entity.projectile.DamagingProjectileEntity;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JParticleManager;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class FloroMudEntity
extends DamagingProjectileEntity
implements ItemSupplier {
    public FloroMudEntity(EntityType<FloroMudEntity> type, Level world) {
        super(type, world);
    }

    public FloroMudEntity(EntityType<FloroMudEntity> type, Level world, LivingEntity thrower, float damage) {
        super(type, world, thrower, damage);
    }

    public FloroMudEntity(Level world, LivingEntity thrower, float damage) {
        super((EntityType<? extends DamagingProjectileEntity>)((EntityType)JEntities.FLORO_MUD_TYPE.get()), world, thrower, damage);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick() {
        super.onClientTick();
        int count = 2;
        Vec3 vector3d = this.m_20184_();
        double d0 = this.m_20185_() + vector3d.f_82479_;
        double d1 = this.m_20186_() + vector3d.f_82480_;
        double d2 = this.m_20189_() + vector3d.f_82481_;
        for (int i = 0; i < count; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)JParticleManager.MUD.get(), d0 - vector3d.f_82479_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, d1 - vector3d.f_82480_ + 0.25, d2 - vector3d.f_82481_ * 0.25 + this.f_19796_.m_188500_() * 0.6 - 0.3, vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
        }
    }

    @Override
    protected void onEntityImpact(HitResult result, Entity target) {
        if (target instanceof LivingEntity && target.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), this.getDamage())) {
            MobEffectInstance effectInstance = new MobEffectInstance(MobEffects.f_19597_, 20);
            ((LivingEntity)target).m_7292_(effectInstance);
        }
    }

    @Override
    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            if (result.m_6662_() != HitResult.Type.MISS) {
                this.m_9236_().m_5594_(null, BlockPos.m_274446_((Position)result.m_82450_()), (SoundEvent)JSounds.MUD_BLOCK_BREAK.get(), SoundSource.AMBIENT, 1.0f, 1.5f);
            }
        } else {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    protected float m_7139_() {
        return 0.03f;
    }

    @NotNull
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)JItems.MUD_BALL.get());
    }
}

