/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public abstract class JThrowableProjectile
extends ThrowableProjectile {
    private int damage = 0;
    private int fireTicks = 0;
    private int potionTicks = 0;
    private boolean isBouncy = false;
    private boolean isFire = false;
    private boolean isPotion = false;
    private MobEffect potion;

    protected JThrowableProjectile(EntityType<? extends ThrowableProjectile> e, Level l) {
        super(e, l);
    }

    public JThrowableProjectile(EntityType<? extends ThrowableProjectile> e, int damage, Level world, LivingEntity thrower) {
        super(e, thrower, world);
        this.damage = damage;
    }

    public void setPotionEffect(MobEffect potion, int ticks) {
        this.isPotion = true;
        this.potionTicks = ticks;
        this.potion = potion;
    }

    public void setFire(int fireTicks) {
        this.isFire = true;
        this.fireTicks = fireTicks;
    }

    public void setBouncy() {
        this.isBouncy = true;
    }

    protected void m_5790_(@NotNull EntityHitResult res) {
        super.m_5790_(res);
        Entity entity = res.m_82443_();
        if (entity instanceof LivingEntity) {
            if (this.isPotion && this.potion != null) {
                MobEffectInstance effectInstance = new MobEffectInstance(this.potion, this.potionTicks);
                ((LivingEntity)entity).m_7292_(effectInstance);
            }
            if (this.damage != 0) {
                entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)this.damage);
            }
            if (this.isFire) {
                entity.m_7311_(this.fireTicks);
            }
        }
    }

    public int getEntityDamage() {
        return this.damage;
    }

    protected void m_6532_(@NotNull HitResult res) {
        super.m_6532_(res);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            if (!this.isBouncy) {
                this.m_146870_();
            }
        }
    }

    protected void m_8097_() {
    }
}

