/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import net.jitl.common.entity.projectile.AbstractKnifeEntity;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class KnifeEntity
extends AbstractKnifeEntity
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(KnifeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private int durability;

    public KnifeEntity(EntityType<KnifeEntity> type, Level world) {
        super(type, world);
    }

    public KnifeEntity(LivingEntity owner, Level worldIn, ItemStack stack, float damage) {
        super((EntityType<? extends AbstractArrow>)((EntityType)JEntities.KNIFE_TYPE.get()), worldIn, owner);
        this.m_36781_(damage);
        this.setStack(stack.m_41777_());
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)JSounds.KNIFE.get();
    }

    @Override
    public void onClientTick() {
        super.onClientTick();
        if (this.isFireKnife(this.getStack().m_41720_())) {
            double d0 = this.m_20185_() + 0.0;
            double d1 = this.m_20186_() + 0.0;
            double d2 = this.m_20189_() + 0.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public boolean isFireKnife(Item item) {
        return item == JItems.MOLTEN_KNIFE.get() || item == JItems.CHARRED_KNIFE.get();
    }

    protected void m_5790_(@NotNull EntityHitResult entityRayTraceResult_) {
        Entity entity = entityRayTraceResult_.m_82443_();
        if (entity instanceof LivingEntity && entity != this.m_19749_()) {
            if (!this.m_9236_().m_5776_()) {
                if (entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)this.m_36789_()) && this.isFireKnife(this.getStack().m_41720_())) {
                    entity.m_20254_(10);
                }
                this.m_5496_((SoundEvent)JSounds.KNIFE.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            }
        } else {
            super.m_5790_(entityRayTraceResult_);
        }
    }

    public boolean isInGround() {
        return this.f_36703_;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("dur", this.getStack().m_41773_());
        nbt.m_128365_("stack", (Tag)this.getStack().m_41739_(new CompoundTag()));
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.durability = nbt.m_128451_("dur");
        this.setStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack")));
        if (this.getStack().m_41619_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void setStack(ItemStack stack) {
        this.m_20088_().m_135381_(STACK, (Object)stack);
    }

    private ItemStack getStack() {
        return (ItemStack)this.m_20088_().m_135370_(STACK);
    }

    @Override
    @NotNull
    public Item pickupItem() {
        ItemStack item = this.getStack().m_41777_();
        item.m_41721_(this.durability);
        return item.m_41720_();
    }

    @NotNull
    public ItemStack m_7846_() {
        ItemStack stack = this.getStack();
        return stack.m_41619_() ? new ItemStack((ItemLike)JItems.IRON_THROWING_KNIFE.get()) : stack;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(STACK, (Object)ItemStack.f_41583_);
        super.m_8097_();
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key == STACK) {
            this.getStack().m_41636_((Entity)this);
        }
        super.m_7350_(key);
    }
}

