/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.projectile;

import java.util.List;
import net.jitl.core.init.internal.JEntities;
import net.jitl.core.init.internal.JItems;
import net.jitl.core.init.internal.JSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PiercerEntity
extends AbstractArrow
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(PiercerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private float velocityMultiplier;
    private double rangeAddend;
    private int flameAddend;
    private int faithfulLevel;
    private boolean launch = false;
    private int currentBounces;
    private int maxBounces;
    public int soundTickCount;

    public PiercerEntity(LivingEntity shooter, Level worldIn, ItemStack stack, int maxBounces, float damage) {
        super((EntityType)JEntities.PIERCER_TYPE.get(), shooter, worldIn);
        this.setStack(stack.m_41777_());
        this.m_36740_((SoundEvent)JSounds.PIERCER.get());
        this.maxBounces = maxBounces;
        this.m_36781_(damage);
    }

    public PiercerEntity(EntityType<PiercerEntity> eucaPiercerEntityEntityType, Level world) {
        super(eucaPiercerEntityEntityType, world);
        this.m_36740_((SoundEvent)JSounds.PIERCER.get());
    }

    public void setVelocityMultiplier(float velocityMultiplier) {
        this.velocityMultiplier = velocityMultiplier;
    }

    public float getVelocityMultiplier() {
        return this.velocityMultiplier;
    }

    public void setRangeAddend(double rangeAddend) {
        this.rangeAddend = rangeAddend;
    }

    public double getRangeAddend() {
        return this.rangeAddend;
    }

    public void setFlameAddend(int flameAddend) {
        this.flameAddend = flameAddend;
    }

    public void setFaithfulLevel(int level) {
        this.faithfulLevel = level;
    }

    public int getFlameAddend() {
        return this.flameAddend;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!(this.m_36797_() || this.isInGround() || this.m_20068_())) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.025, 0.0));
        }
        if (this.launch) {
            Entity bounceTo = null;
            if (++this.currentBounces <= this.maxBounces) {
                List entitiesNear = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(4.0 + this.getRangeAddend()));
                for (LivingEntity e : entitiesNear) {
                    if (e == this.m_19749_() || !this.pathTo((Entity)e) || e.f_19802_ != 0 || e.m_21224_() || e.getClassification(false) != MobCategory.MONSTER || bounceTo != null && !(this.m_20270_((Entity)e) < this.m_20270_(bounceTo))) continue;
                    bounceTo = e;
                }
            }
            if (bounceTo == null) {
                bounceTo = this.m_19749_();
            }
            if (bounceTo != null) {
                Vec3 movement = new Vec3(bounceTo.m_20185_(), bounceTo.m_20227_(0.8), bounceTo.m_20189_()).m_82492_(this.m_20185_(), this.m_20227_(0.5), this.m_20189_());
                this.m_20256_(movement.m_82490_((0.7 + (double)this.getVelocityMultiplier() / 6.5) / movement.m_82553_() * this.m_20184_().m_82553_()));
            }
            this.launch = false;
        }
        if (this.faithfulLevel > 0) {
            Entity entity = this.m_19749_();
            if (this.isInGround() && this.isAcceptibleReturnOwner() && entity != null) {
                this.m_36790_(true);
                Vec3 vector3d = new Vec3(entity.m_20185_() - this.m_20185_(), entity.m_20188_() - this.m_20186_(), entity.m_20189_() - this.m_20189_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vector3d.f_82480_ * 0.015 * (double)this.faithfulLevel, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.15 * (double)this.faithfulLevel;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vector3d.m_82541_().m_82490_(d0)));
                if (this.soundTickCount == 0) {
                    this.m_5496_((SoundEvent)JSounds.PIERCER_RETURN.get(), 10.0f, Mth.m_216267_((RandomSource)this.f_19796_, (float)0.8f, (float)1.2f));
                }
                ++this.soundTickCount;
            }
        }
        if (this.getStack().m_41619_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12018_, SoundSource.AMBIENT, 1.0f, 1.0f);
            this.m_146870_();
        }
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    private boolean pathTo(Entity entityIn) {
        Vec3 vector3d = new Vec3(this.m_20185_(), this.m_20227_(0.5), this.m_20189_());
        Vec3 vector3d1 = new Vec3(entityIn.m_20185_(), entityIn.m_20227_(0.8), entityIn.m_20189_());
        return this.m_9236_().m_45547_(new ClipContext(vector3d, vector3d1, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    protected void m_5790_(EntityHitResult entityRayTraceResult_) {
        Entity entity = entityRayTraceResult_.m_82443_();
        if (entity instanceof LivingEntity && entity != this.m_19749_() && !this.m_9236_().m_5776_()) {
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity2;
                this.getStack().m_41622_(1, (LivingEntity)player, context -> context.m_21190_(player.m_7655_()));
            }
            if (entity.m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), (float)this.m_36789_())) {
                if (this.getFlameAddend() > 0) {
                    entity.m_20254_(this.getFlameAddend() * 4);
                }
                this.launch = true;
            }
            this.m_5496_((SoundEvent)JSounds.PIERCER.get(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        }
    }

    public void m_6123_(@NotNull Player entityIn) {
        if (!this.m_9236_().f_46443_) {
            boolean isOwner;
            boolean bl = isOwner = this.m_19749_().m_20148_() == entityIn.m_20148_();
            if (isOwner && this.currentBounces > 0 || (this.f_36703_ || this.m_36797_()) && this.f_36706_ <= 0) {
                boolean flag;
                boolean bl2 = flag = this.f_36705_ == AbstractArrow.Pickup.ALLOWED || this.f_36705_ == AbstractArrow.Pickup.CREATIVE_ONLY && entityIn.m_36337_() || this.m_36797_() && isOwner;
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED && !entityIn.m_150109_().m_36054_(this.m_7941_())) {
                    flag = false;
                }
                if (flag) {
                    entityIn.m_7938_((Entity)this, 1);
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        }
    }

    public boolean isInGround() {
        return this.f_36703_;
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("stack", (Tag)this.getStack().m_41739_(new CompoundTag()));
        nbt.m_128405_("bounces", this.currentBounces);
        nbt.m_128405_("maxBounces", this.maxBounces);
        nbt.m_128350_("velocityMultiplier", this.velocityMultiplier);
        nbt.m_128347_("rangeAddend", this.rangeAddend);
        nbt.m_128405_("flameAddend", this.flameAddend);
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("stack")));
        if (this.getStack().m_41619_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.currentBounces = nbt.m_128451_("bounces");
        this.maxBounces = nbt.m_128451_("maxBounces");
        this.velocityMultiplier = nbt.m_128457_("velocityMultiplier");
        this.rangeAddend = nbt.m_128459_("rangeAddend");
        this.flameAddend = nbt.m_128451_("flameAddend");
    }

    private void setStack(ItemStack stack) {
        this.m_20088_().m_135381_(STACK, (Object)stack);
    }

    private ItemStack getStack() {
        return (ItemStack)this.m_20088_().m_135370_(STACK);
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.getStack().m_41777_();
    }

    @NotNull
    public ItemStack m_7846_() {
        ItemStack stack = this.getStack();
        return stack.m_41619_() ? new ItemStack((ItemLike)JItems.PIERCER.get()) : stack;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(STACK, (Object)ItemStack.f_41583_);
        super.m_8097_();
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        if (key == STACK) {
            this.getStack().m_41636_((Entity)this);
        }
        super.m_7350_(key);
    }
}

