/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.entity.terrania;

import javax.annotation.Nullable;
import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.entity.base.JMonsterEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class AranaKing
extends JMonsterEntity {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(AranaKing.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final RawAnimation IDLE = RawAnimation.begin().thenLoop("animation.arana_king.idle");
    private final RawAnimation MOVING = RawAnimation.begin().thenLoop("animation.arana_king.walk");

    public AranaKing(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setKnowledge(EnumKnowledge.TERRANIA, 5.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new AranaAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new AranaTargetGoal<Player>(this, Player.class));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12432_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12434_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22281_, 13.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22279_, 0.26).m_22265_();
    }

    @Override
    protected void controller(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.MOVING);
            }
            return state.setAndContinue(this.IDLE);
        })});
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new WallClimberNavigation((Mob)this, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_7601_(BlockState pState, @NotNull Vec3 pMotionMultiplier) {
        if (!pState.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(pState, pMotionMultiplier);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean pClimbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = pClimbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        Skeleton skeleton;
        pSpawnData = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        RandomSource randomsource = pLevel.m_213780_();
        if (randomsource.m_188503_(100) == 0 && (skeleton = (Skeleton)EntityType.f_20524_.m_20615_(this.m_9236_())) != null) {
            skeleton.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
            skeleton.m_6518_(pLevel, pDifficulty, pReason, null, null);
            skeleton.m_20329_((Entity)this);
        }
        if (pSpawnData == null) {
            pSpawnData = new AranaEffectsGroupData();
            if (pLevel.m_46791_() == Difficulty.HARD && randomsource.m_188501_() < 0.1f * pDifficulty.m_19057_()) {
                ((AranaEffectsGroupData)pSpawnData).setRandomEffect(randomsource);
            }
        }
        if (pSpawnData instanceof AranaEffectsGroupData) {
            AranaEffectsGroupData e = (AranaEffectsGroupData)pSpawnData;
            MobEffect mobeffect = e.effect;
            if (mobeffect != null) {
                this.m_7292_(new MobEffectInstance(mobeffect, -1));
            }
        }
        return pSpawnData;
    }

    public double m_6048_() {
        return this.m_20206_() * 0.5f;
    }

    static class AranaAttackGoal
    extends MeleeAttackGoal {
        public AranaAttackGoal(AranaKing arana) {
            super((PathfinderMob)arana, 1.0, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        public boolean m_8045_() {
            float f = this.f_25540_.m_213856_();
            if (f >= 0.5f && this.f_25540_.m_217043_().m_188503_(100) == 0) {
                this.f_25540_.m_6710_(null);
                return false;
            }
            return super.m_8045_();
        }
    }

    static class AranaTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public AranaTargetGoal(AranaKing a, Class<T> pEntityTypeToTarget) {
            super((Mob)a, pEntityTypeToTarget, true);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return !(f >= 0.5f) && super.m_8036_();
        }
    }

    public static class AranaEffectsGroupData
    implements SpawnGroupData {
        @Nullable
        public MobEffect effect;

        public void setRandomEffect(RandomSource pRandom) {
            int i = pRandom.m_188503_(5);
            if (i <= 1) {
                this.effect = MobEffects.f_19596_;
            } else if (i <= 2) {
                this.effect = MobEffects.f_19600_;
            } else if (i <= 3) {
                this.effect = MobEffects.f_19605_;
            } else if (i <= 4) {
                this.effect = MobEffects.f_19609_;
            }
        }
    }
}

