/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.event;

import net.jitl.client.knowledge.EnumKnowledge;
import net.jitl.common.capability.stats.PlayerStatsProvider;
import net.jitl.core.config.JCommonConfig;
import net.jitl.core.init.internal.JItems;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jitl")
public class DeathEvent {
    @SubscribeEvent
    public static void onEntityDrop(LivingDropsEvent event) {
        RandomSource random = RandomSource.m_216327_();
        LivingEntity entity = event.getEntity();
        Entity entity2 = event.getSource().m_7639_();
        if (entity2 instanceof Player) {
            Player player = (Player)entity2;
            player.getCapability(PlayerStatsProvider.PLAYER_STATS).ifPresent(stats -> {
                if (DeathEvent.isOverworldAnimal(entity)) {
                    stats.addXP(EnumKnowledge.OVERWORLD, 2.5f, player);
                }
                if (DeathEvent.isOverworldMob(entity)) {
                    stats.addXP(EnumKnowledge.OVERWORLD, 5.0f, player);
                }
                if (DeathEvent.isNetherMob(entity)) {
                    stats.addXP(EnumKnowledge.NETHER, 5.0f, player);
                }
                if (DeathEvent.isEndMob(entity)) {
                    stats.addXP(EnumKnowledge.END, 5.0f, player);
                }
                if (DeathEvent.higherEndXP(entity)) {
                    stats.addLevel(EnumKnowledge.END, 100);
                }
                if (DeathEvent.higherOverworldXP(entity)) {
                    stats.addLevel(EnumKnowledge.OVERWORLD, 10);
                }
            });
            if (entity instanceof Ghast && random.m_188503_(3) == 0) {
                entity.m_20000_((ItemLike)JItems.GHAST_TENTACLE.get(), 1);
            }
            if (((Boolean)JCommonConfig.ENABLE_LOOT_POUCH_DROP.get()).booleanValue()) {
                if (random.m_188503_(((Integer)JCommonConfig.COMMON_LOOT_CHANCE.get()).intValue()) == 0) {
                    entity.m_20000_((ItemLike)JItems.LOOT_POUCH.get(), 1);
                }
                if (random.m_188503_(((Integer)JCommonConfig.GOLD_LOOT_CHANCE.get()).intValue()) == 0) {
                    entity.m_20000_((ItemLike)JItems.GOLD_LOOT_POUCH.get(), 1);
                }
                if (random.m_188503_(((Integer)JCommonConfig.DIAMOND_LOOT_CHANCE.get()).intValue()) == 0) {
                    entity.m_20000_((ItemLike)JItems.DIAMOND_LOOT_POUCH.get(), 1);
                }
            }
        }
    }

    public static boolean isOverworldAnimal(LivingEntity entity) {
        return entity instanceof Sheep || entity instanceof Pig || entity instanceof Cow || entity instanceof Horse || entity instanceof Llama || entity instanceof Squid || entity instanceof Axolotl || entity instanceof Bat || entity instanceof Bee || entity instanceof Camel || entity instanceof Cat || entity instanceof Chicken || entity instanceof Cod || entity instanceof Frog || entity instanceof Donkey || entity instanceof Dolphin || entity instanceof Fox || entity instanceof Goat || entity instanceof Mule || entity instanceof Ocelot || entity instanceof Panda || entity instanceof Parrot || entity instanceof PolarBear || entity instanceof Sniffer || entity instanceof SnowGolem || entity instanceof Tadpole || entity instanceof TropicalFish || entity instanceof Turtle || entity instanceof Wolf;
    }

    public static boolean isOverworldMob(LivingEntity entity) {
        return entity instanceof Skeleton || entity instanceof Creeper || entity instanceof Ravager || entity instanceof Silverfish || entity instanceof Slime || entity instanceof SpellcasterIllager || entity instanceof Spider || entity instanceof Stray || entity instanceof Strider || entity instanceof Vex || entity instanceof Vindicator || entity instanceof Witch || entity instanceof Zombie || entity instanceof Allay || entity instanceof IronGolem || entity instanceof Phantom;
    }

    public static boolean isNetherMob(LivingEntity entity) {
        return entity instanceof WitherSkeleton || entity instanceof ZombifiedPiglin || entity instanceof MagmaCube || entity instanceof Blaze || entity instanceof Zoglin || entity instanceof Piglin;
    }

    public static boolean isEndMob(LivingEntity entity) {
        return entity instanceof EnderMan || entity instanceof Endermite || entity instanceof Shulker;
    }

    public static boolean higherEndXP(LivingEntity entity) {
        return entity instanceof EnderDragon;
    }

    public static boolean higherOverworldXP(LivingEntity entity) {
        return entity instanceof ElderGuardian || entity instanceof Warden;
    }
}

