/*
 * Decompiled with CFR 0.152.
 */
package net.jitl.common.event;

import java.util.ArrayList;
import java.util.Objects;
import net.jitl.common.capability.gear.PlayerArmorProvider;
import net.jitl.common.items.base.JArmorItem;
import net.jitl.common.items.gear.FullArmorAbility;
import net.jitl.common.items.gear.JGear;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jitl")
public class GearAbilityHandler {
    @SubscribeEvent
    public static void handleTick(LivingEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_150109_() != null) {
                ItemStack hand = player.m_21205_();
                Item item = hand.m_41720_();
                if (item instanceof JGear && !(item instanceof JArmorItem)) {
                    ((JGear)hand.m_41720_()).getAbility().tick((LivingEntity)player, player.m_9236_(), hand);
                }
                if ((item = (hand = player.m_21206_()).m_41720_()) instanceof JGear && !(item instanceof JArmorItem)) {
                    ((JGear)hand.m_41720_()).getAbility().tick((LivingEntity)player, player.m_9236_(), hand);
                }
            }
            event.getEntity().getCapability(PlayerArmorProvider.PLAYER_ARMOR).ifPresent(armor -> {
                FullArmorAbility fullSet;
                ArrayList<ItemStack> stacks = armor.getArmor();
                if (stacks != null) {
                    for (ItemStack stack : stacks) {
                        if (!(stack.m_41720_() instanceof JArmorItem)) continue;
                        Objects.requireNonNull(((JArmorItem)stack.m_41720_()).getAbility()).tick((LivingEntity)player, player.m_9236_(), stack);
                    }
                }
                if ((fullSet = armor.getFullArmor()) != null) {
                    fullSet.tick((LivingEntity)player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void handleIncomingAttack(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7640_();
        if (entity != null) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack stack = living.m_21205_();
                Item item = stack.m_41720_();
                if (item instanceof JGear) {
                    ((JGear)item).getAbility().attackTarget(living, stack, event);
                }
            } else if (entity.m_6095_() == EntityType.f_20548_ && ((Arrow)entity).m_19749_() instanceof LivingEntity) {
                for (ItemStack itemStack : ((Arrow)entity).m_19749_().m_6168_()) {
                    Item current = itemStack.m_41720_();
                    if (current instanceof ArmorItem && ((ArmorItem)current).m_40401_() == ArmorMaterials.LEATHER) continue;
                    return;
                }
                event.setAmount(event.getAmount() + 5.0f);
            }
        }
    }

    @SubscribeEvent
    public static void handleDamageDealt(LivingDamageEvent event) {
        LivingEntity living;
        ItemStack stack;
        Item item;
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof LivingEntity && (item = (stack = (living = (LivingEntity)entity).m_21205_()).m_41720_()) instanceof JGear) {
            ((JGear)item).getAbility().damageTarget(living, stack, event);
        }
        event.getEntity().getCapability(PlayerArmorProvider.PLAYER_ARMOR).ifPresent(armor -> {
            if (armor.getFullArmor() != null) {
                armor.getFullArmor().hit(event);
            }
        });
    }

    public static void onKeyPressed(Player player) {
        if (player != null) {
            player.getCapability(PlayerArmorProvider.PLAYER_ARMOR).ifPresent(playerArmor -> {
                FullArmorAbility armor = playerArmor.getFullArmor();
                if (armor != null) {
                    armor.keyPressed((LivingEntity)player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void equipmentChange(LivingEquipmentChangeEvent event) {
        Item item = event.getFrom().m_41720_();
        LivingEntity entity = event.getEntity();
        EquipmentSlot slot = event.getSlot();
        if (item instanceof JGear) {
            ((JGear)item).getAbility().unEquip(entity, slot, event.getFrom());
        }
        if ((item = event.getTo().m_41720_()) instanceof JGear) {
            ((JGear)item).getAbility().equip(entity, slot, event.getTo());
        }
        if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            entity.getCapability(PlayerArmorProvider.PLAYER_ARMOR).ifPresent(playerArmor -> playerArmor.setArmor(entity.m_6168_().iterator()));
        }
    }
}

